/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.ocr;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.domain.config.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrConfigServe;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Deprecated
@Extractor(group=ExtractorGroupEnum.OCR, name="OCR-\u6587\u672c\u63d0\u53d6", order=23)
public class OcrTextOldExtractor
extends AbstractDefaultExtractor<FileBytesInfo, String, OcrTextConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrTextOldExtractor.class);
    private String old = "{\n    \"rules\": {\n        \"date\": [\n\n        ],\n        \"number\": [\n\n        ],\n        \"seal\": [\n\n        ],\n        \"sign\": [\n\n        ],\n        \"table\": [\n\n        ],\n        \"text\": [\n            {\n                \"element_name\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 6,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\uff1a(.*)\"\n                ],\n                \"target_row\": 1,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"7dafbac90d9640d391ea66b0538b51e5\",\n                \"handleType\": \"text\",\n                \"key\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            },\n            {\n                \"element_name\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 4,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u7f16\u5236\u5355\u4f4d\uff1a(.*)\"\n                ],\n                \"target_row\": 4,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"d3475eacbddb4ff4ba39ab01f51a5076\",\n                \"handleType\": \"text\",\n                \"key\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            },\n            {\n                \"element_name\": \"\u5ba1\u6838\u4eba\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u5ba1 \u6838\uff1a\u5468\u6cfd\u5b8f\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 7,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u5ba1  \u6838\uff1a(.*)\"\n                ],\n                \"target_row\": 1,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"e075ad4a84432826e75369c369f73716\",\n                \"handleType\": \"text\",\n                \"key\": \"\u5ba1\u6838\u4eba\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            }\n        ],\n        \"writedate\": [\n\n        ],\n        \"defined_table\": [\n\n        ]\n    }\n}";
    private String extractJsonStr = "{\"rules\":{\"date\":[],\"number\":[],\"seal\":[],\"sign\":[],\"table\":[],\"text\":[],\"writedate\":[],\"defined_table\":[]}}";
    private String identifyJson = "{\"global_param\":{\"pdf_num\":99,\"continuous_page_number\":false,\"recognitionRange\":\"0\",\"object_setting\":{\"seal_det\":true,\"seal_det_thresh\":0.5,\"sign_det\":true,\"sign_det_thresh\":0.5,\"writedate_det\":false,\"writedate_det_thresh\":0.5,\"writedate_rec\":false,\"table_det\":false,\"seal_elim\":true,\"seal_elim_type\":\"unet\",\"watermark_elim\":false,\"watermark_elim_thresh\":100,\"seal_rec\":true}}}";
    @Autowired
    private OcrConfigServe ocrConfigServe;

    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.OCR_TEXT_OLD;
    }

    @Override
    public Class<?> outputClass() {
        return String.class;
    }

    @Override
    protected CategoryDto categoryDto() {
        return this.stringCategoryDto();
    }

    @Override
    public ExtractorCarrier<String> outPut(List<FileBytesInfo> input, OcrTextConfig config) {
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (FileBytesInfo bytesInfo : input) {
            ArrayList<OcrTextConfig> texts = new ArrayList<OcrTextConfig>();
            if (StringUtils.isEmpty((Object)config.getIndex_trend())) {
                config.setIndex_trend("left");
                config.setKey(config.getElement_name());
            }
            if (StringUtils.isEmpty((Object)config.getRegex())) {
                config.setPattern(new ArrayList<String>(Collections.singletonList("(.*)")));
            } else {
                config.setPattern(new ArrayList<String>(Collections.singletonList(config.getRegex())));
            }
            texts.add(config);
            HashMap map = new HashMap(JSON.parseObject((String)this.identifyJson));
            JSONObject extractJson = JSON.parseObject((String)this.extractJsonStr);
            JSONObject rules = extractJson.getJSONObject("rules");
            if (CollUtil.isNotEmpty(texts)) {
                rules.put("text", texts);
            }
            map.putAll(extractJson);
            ConfigOcrResponse ocr = this.ocrConfigServe.ocr(map, bytesInfo.getFileFormat(), bytesInfo.getFileBytes());
            String text = (String)ocr.getText().get(config.getKey());
            if (StringUtils.isEmpty((Object)text)) continue;
            data.add(text);
            locations.add(new Location(text));
        }
        return this.carrier(data, locations);
    }
}

