/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.ocr;

import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.configOld.ocr.OcrTextFromParaConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.util.ocr.OcrParagraph;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.AbstractExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;

@Extractor(group=ExtractorGroupEnum.OCR, name="OCR-\u6bb5\u843d\u6587\u672c\u63d0\u53d6", order=24)
public class OcrTextFromParaExtractor
extends AbstractExtractor<OcrParagraph, String, OcrTextFromParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.OCR_PARA.getCode(), ExtractorEnum.OCR_TEXT.getCode());
    }

    @Override
    public List<String> extract(List<OcrParagraph> paragraphs, OcrTextFromParaConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (OcrParagraph paragraph : paragraphs) {
            if (!MatchTextUtil.isMatch((String)config.getParaRegex(), (String)paragraph.getText()).booleanValue()) continue;
            result.addAll(MatchTextUtil.match((String)config.getRegex(), (String)paragraph.getText()));
        }
        return result;
    }
}

