/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.ocr;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.domain.configOld.ExtractorConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.util.OcrInfo;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.AbstractExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrServer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Extractor(group=ExtractorGroupEnum.OCR, name="OCR-\u4fe1\u606f\u63d0\u53d6", order=21)
public class OcrInfoExtractor
extends AbstractExtractor<FileBytesInfo, OcrInfo, ExtractorConfig> {
    @Autowired
    private OcrServer server;

    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.FILE_BYTES_INFO.getCode(), ExtractorEnum.OCR_INFO.getCode());
    }

    @Override
    public List<OcrInfo> extract(List<FileBytesInfo> bytesInfos, ExtractorConfig config) {
        ArrayList<OcrInfo> ocrInfos = new ArrayList<OcrInfo>();
        for (FileBytesInfo bytesInfo : bytesInfos) {
            ocrInfos.add(this.server.getOcrInfo(bytesInfo));
        }
        return ocrInfos;
    }
}

