/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.word;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.word.WordTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Word-\u8868\u683c\u63d0\u53d6", order=14)
public class WordTableExtractor
extends AbstractDefaultExtractor<WordInfo, WordTableInfo, WordTableConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.WORD_TABLE;
    }

    @Override
    public Class<?> outputClass() {
        return WordTableInfo.class;
    }

    @Override
    public ExtractorCarrier<WordTableInfo> outPut(List<WordInfo> wordInfos, WordTableConfig config) {
        ArrayList<WordTableInfo> data = new ArrayList<WordTableInfo>();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (WordInfo wordInfo : wordInfos) {
            List elementInfos = wordInfo.getElementInfos();
            for (int i = 0; i < elementInfos.size(); ++i) {
                WordElementInfo wordElementInfo = (WordElementInfo)elementInfos.get(i);
                if (!"para".equals(wordElementInfo.getType())) continue;
                WordParagraphInfo paragraphInfo = (WordParagraphInfo)wordElementInfo;
                if (!MatchTextUtil.matchOld((String)config.getBasicText(), (String)paragraphInfo.getText())) continue;
                try {
                    WordElementInfo target = (WordElementInfo)elementInfos.get(i + config.getOffset());
                    if (!"table".equals(target.getType())) continue;
                    data.add((WordTableInfo)target);
                    locations.add(new Location());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return this.carrier(data, locations);
    }
}

