/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.util.structure.word;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.extract.domain.util.WordInfo;
import com.jxdinfo.idp.extract.domain.util.word.TableIndex;
import com.jxdinfo.idp.extract.domain.util.word.WordCellInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordChapterInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordElementInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordFooter;
import com.jxdinfo.idp.extract.domain.util.word.WordHeader;
import com.jxdinfo.idp.extract.domain.util.word.WordParagraphInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordRowInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordTableInfo;
import com.jxdinfo.idp.extract.util.structure.word.WordStructureUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxStructureUtil
extends WordStructureUtil {
    private static final Logger log = LoggerFactory.getLogger(DocxStructureUtil.class);

    @Override
    public WordInfo getWordInfo(InputStream is, String fileName) {
        WordInfo result = new WordInfo();
        try (XWPFDocument document = new XWPFDocument(is);){
            ArrayList<WordChapterInfo> chapterInfos = new ArrayList<WordChapterInfo>();
            result.setChapterInfos(chapterInfos);
            ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
            result.setElementInfos(elementInfos);
            ArrayList<WordTableInfo> tInfos = new ArrayList<WordTableInfo>();
            result.setTableInfos(tInfos);
            Iterator iterator = document.getBodyElementsIterator();
            int pIndex = -1;
            int tIndex = -1;
            int index = -1;
            while (iterator.hasNext()) {
                IBodyElement element = (IBodyElement)iterator.next();
                if (element.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                    ++index;
                    XWPFParagraph paragraph = element.getBody().getParagraphArray(++pIndex);
                    String text = paragraph.getParagraphText();
                    WordParagraphInfo info = new WordParagraphInfo();
                    elementInfos.add((WordElementInfo)info);
                    info.setPoiIndex(Integer.valueOf(pIndex));
                    info.setText(text);
                    info.setIndex(Integer.valueOf(index));
                    int pLevel = this.pLevel(document, paragraph);
                    if (pLevel == 0 || pLevel == 10) continue;
                    WordChapterInfo content = new WordChapterInfo();
                    content.setTitleName(text);
                    content.setLevel(Integer.valueOf(pLevel));
                    content.setStartIndex(Integer.valueOf(index));
                    chapterInfos.add(content);
                    continue;
                }
                if (!element.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                ++tIndex;
                ++index;
                WordTableInfo info = new WordTableInfo();
                tInfos.add(info);
                elementInfos.add((WordElementInfo)info);
                TableIndex tableIndex = new TableIndex();
                tableIndex.setPoiIndex(Integer.valueOf(tIndex));
                info.getTableIndices().add(tableIndex);
                info.setPoiIndex(Integer.valueOf(tIndex));
                info.setIndex(Integer.valueOf(index));
                this.assembleTable(tInfos, info, element.getBody().getTableArray(tIndex));
            }
            this.assembleChapter(chapterInfos, elementInfos);
        }
        catch (Exception e) {
            log.error("docx\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01", (Throwable)e);
        }
        return result;
    }

    private List<WordFooter> getFooters(XWPFDocument document) {
        ArrayList<WordFooter> result = new ArrayList<WordFooter>();
        List footers = document.getFooterList();
        for (int i = 0; i < footers.size(); ++i) {
            WordFooter wordFooter = new WordFooter();
            wordFooter.setIndex(Integer.valueOf(i));
            wordFooter.setText(((XWPFFooter)footers.get(i)).getText());
            result.add(wordFooter);
        }
        return result;
    }

    private List<WordHeader> getHeaders(XWPFDocument document) {
        ArrayList<WordHeader> result = new ArrayList<WordHeader>();
        List headers = document.getHeaderList();
        for (int i = 0; i < headers.size(); ++i) {
            WordHeader wordHeader = new WordHeader();
            wordHeader.setIndex(Integer.valueOf(i));
            wordHeader.setText(((XWPFHeader)headers.get(i)).getText());
            result.add(wordHeader);
        }
        return result;
    }

    private int pLevel(XWPFDocument doc, XWPFParagraph para) {
        try {
            if (para.getCTP().getPPr().getOutlineLvl() != null) {
                return para.getCTP().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl() != null) {
                return doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal()).getCTStyle().getPPr().getOutlineLvl() != null) {
                String styleName = doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal();
                return doc.getStyles().getStyle(styleName).getCTStyle().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private void assembleChapter(List<WordChapterInfo> chapterInfos, List<WordElementInfo> elementInfos) {
        block0: for (int i = 0; i < chapterInfos.size(); ++i) {
            for (int j = i + 1; j < chapterInfos.size(); ++j) {
                WordChapterInfo current = chapterInfos.get(i);
                WordChapterInfo next = chapterInfos.get(j);
                if (current.getLevel() >= next.getLevel()) {
                    current.setEndIndex(next.getStartIndex());
                    continue block0;
                }
                if (j != chapterInfos.size() - 1) continue;
                current.setEndIndex(Integer.valueOf(elementInfos.size()));
                continue block0;
            }
        }
        if (CollectionUtil.isNotEmpty(chapterInfos)) {
            chapterInfos.get(chapterInfos.size() - 1).setEndIndex(Integer.valueOf(elementInfos.size()));
        }
        for (WordChapterInfo chapterInfo : chapterInfos) {
            chapterInfo.setEInfoList(new ArrayList());
            StringBuilder text = new StringBuilder();
            Integer i = chapterInfo.getStartIndex();
            while (i < chapterInfo.getEndIndex()) {
                WordElementInfo eInfo = elementInfos.get(i);
                chapterInfo.getEInfoList().add(eInfo);
                if (i > chapterInfo.getStartIndex()) {
                    if ("para".equals(eInfo.getType())) {
                        WordParagraphInfo pInfo = (WordParagraphInfo)eInfo;
                        text.append(pInfo.getText()).append("\n");
                    } else if ("table".equals(eInfo.getType())) {
                        text.append("\u3010\u8868\u683c\u3011\n");
                    }
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            chapterInfo.setText(text.toString());
        }
    }

    private void assembleTable(List<WordTableInfo> tInfos, WordTableInfo parentTInfo, XWPFTable table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        parentTInfo.setRows(rowInfos);
        List rows = table.getRows();
        for (int j = 0; j < rows.size(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfo.setIndex(Integer.valueOf(j));
            rowInfos.add(rowInfo);
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            XWPFTableRow row = table.getRow(j);
            List tableCells = row.getTableCells();
            for (int k = 0; k < tableCells.size(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfo.setIndex(Integer.valueOf(k));
                cellInfos.add(cellInfo);
                XWPFTableCell cell = row.getCell(k);
                cellInfo.setText(cell.getText().trim());
                this.handleCell(cellInfo, cell, k, j, table);
                ArrayList<Object> elementInfos = new ArrayList<Object>();
                cellInfo.setElementInfos(elementInfos);
                int pIndex = 0;
                int tIndex = 0;
                List bodyElements = cell.getBodyElements();
                for (IBodyElement bodyElement : bodyElements) {
                    if (bodyElement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                        XWPFParagraph paragraph = bodyElement.getBody().getParagraphArray(pIndex);
                        WordParagraphInfo pInfo = new WordParagraphInfo();
                        elementInfos.add(pInfo);
                        pInfo.setPoiIndex(Integer.valueOf(pIndex));
                        pInfo.setType("para");
                        pInfo.setText(paragraph.getText().trim());
                        ++pIndex;
                        continue;
                    }
                    if (!bodyElement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                    XWPFTable childTable = bodyElement.getBody().getTableArray(tIndex);
                    WordTableInfo info = new WordTableInfo();
                    tInfos.add(info);
                    elementInfos.add(info);
                    LinkedList parentTableIndices = parentTInfo.getTableIndices();
                    TableIndex parent = (TableIndex)parentTableIndices.getLast();
                    parent.setRowIndex(Integer.valueOf(j));
                    parent.setCellIndex(Integer.valueOf(k));
                    TableIndex tableIndex = new TableIndex(Integer.valueOf(tIndex));
                    parentTableIndices.forEach(parentTableIndex -> info.getTableIndices().add(parentTableIndex));
                    info.getTableIndices().add(tableIndex);
                    info.setPoiIndex(Integer.valueOf(tIndex));
                    info.setType("table");
                    this.assembleChildTable(tInfos, info, childTable);
                    ++tIndex;
                }
            }
        }
    }

    private void assembleChildTable(List<WordTableInfo> tInfos, WordTableInfo parentTInfo, XWPFTable table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        parentTInfo.setRows(rowInfos);
        List rows = table.getRows();
        for (int j = 0; j < rows.size(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfo.setIndex(Integer.valueOf(j));
            rowInfos.add(rowInfo);
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            XWPFTableRow row = table.getRow(j);
            List tableCells = row.getTableCells();
            for (int k = 0; k < tableCells.size(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfo.setIndex(Integer.valueOf(k));
                cellInfos.add(cellInfo);
                XWPFTableCell cell = row.getCell(k);
                cellInfo.setText(cell.getText().trim());
                this.handleCell(cellInfo, cell, k, j, table);
                ArrayList<Object> elementInfos = new ArrayList<Object>();
                cellInfo.setElementInfos(elementInfos);
                int pIndex = 0;
                int tIndex = 0;
                List bodyElements = cell.getBodyElements();
                for (IBodyElement bodyElement : bodyElements) {
                    if (bodyElement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                        XWPFParagraph paragraph = bodyElement.getBody().getParagraphArray(pIndex);
                        WordParagraphInfo pInfo = new WordParagraphInfo();
                        elementInfos.add(pInfo);
                        pInfo.setPoiIndex(Integer.valueOf(pIndex));
                        pInfo.setType("para");
                        pInfo.setText(paragraph.getText().trim());
                        ++pIndex;
                        continue;
                    }
                    if (!bodyElement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                    XWPFTable childTable = bodyElement.getBody().getTableArray(tIndex);
                    WordTableInfo tInfo = new WordTableInfo();
                    tInfos.add(tInfo);
                    elementInfos.add(tInfo);
                    tInfo.setPoiIndex(Integer.valueOf(tIndex));
                    LinkedList parentTableIndices = parentTInfo.getTableIndices();
                    TableIndex parent = (TableIndex)parentTableIndices.getLast();
                    parent.setRowIndex(Integer.valueOf(j));
                    parent.setCellIndex(Integer.valueOf(k));
                    parentTableIndices.forEach(parentTableIndex -> tInfo.getTableIndices().add(parentTableIndex));
                    tInfo.getTableIndices().add(new TableIndex(Integer.valueOf(tIndex)));
                    tInfo.setType("table");
                    this.assembleChildTable(tInfos, tInfo, childTable);
                    ++tIndex;
                }
            }
        }
    }

    private void handleCell(WordCellInfo cellInfo, XWPFTableCell cell, int x, int y, XWPFTable table) {
        CTDecimalNumber colspan;
        STMerge.Enum vMergeVal;
        CTTc ctTc = cell.getCTTc();
        List rows = table.getRows();
        CTTcPr tcPr = ctTc.getTcPr();
        if (tcPr == null) {
            return;
        }
        CTVMerge rowspan = tcPr.getVMerge();
        int rowspanNum = 1;
        if (rowspan != null && (vMergeVal = rowspan.getVal()) != null && STMerge.RESTART.toString().equals(vMergeVal.toString())) {
            for (int i = y + 1; i < rows.size(); ++i) {
                if (((XWPFTableRow)rows.get(i)).getTableCells().size() > x) {
                    STMerge.Enum nextVMergeVal;
                    CTVMerge nextVMerge = ((XWPFTableRow)rows.get(i)).getCell(x).getCTTc().getTcPr().getVMerge();
                    if (nextVMerge == null || (nextVMergeVal = nextVMerge.getVal()) != null && STMerge.RESTART.toString().equals(nextVMergeVal.toString())) break;
                    ++rowspanNum;
                    continue;
                }
                ++rowspanNum;
            }
        }
        if ((colspan = tcPr.getGridSpan()) != null) {
            cellInfo.setColSpan(Integer.valueOf(colspan.getVal().intValue()));
        } else {
            cellInfo.setColSpan(Integer.valueOf(1));
        }
        if (rowspan != null) {
            if (rowspan.getVal() != null) {
                cellInfo.setRowSpan(Integer.valueOf(rowspanNum));
            }
            if (rowspan.getVal() == null || rowspan.getVal() != STMerge.RESTART) {
                cellInfo.setRowSpan(null);
            }
        } else {
            cellInfo.setRowSpan(Integer.valueOf(1));
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream("C:\\Users\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\\u6d4b\u8bd5\u6587\u6863\\bug\u6d4b\u8bd5\u6587\u4ef6\\\u91cd\u6784docx\u6d4b\u8bd5.docx");
        DocxStructureUtil util = new DocxStructureUtil();
        WordInfo wordInfoNew = util.getWordInfo(inputStream, "\u91cd\u6784docx\u6d4b\u8bd5.docx");
        System.out.println("ddd");
    }
}

