/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.util.structure.word;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.idp.common.enums.DocRegularEnum;
import com.jxdinfo.idp.extract.domain.util.WordInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordCellInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordChapterInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordElementInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordFooter;
import com.jxdinfo.idp.extract.domain.util.word.WordHeader;
import com.jxdinfo.idp.extract.domain.util.word.WordParagraphInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordRowInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordTableInfo;
import com.jxdinfo.idp.extract.util.structure.word.WordStructureUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocStructureUtil
extends WordStructureUtil {
    private static final Logger log = LoggerFactory.getLogger(DocStructureUtil.class);

    @Override
    public WordInfo getWordInfo(InputStream is, String fileName) {
        WordInfo result = new WordInfo();
        try (HWPFDocument document = new HWPFDocument(is);){
            ArrayList<WordChapterInfo> chapterInfos = new ArrayList<WordChapterInfo>();
            result.setChapterInfos(chapterInfos);
            ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
            result.setElementInfos(elementInfos);
            Range range = document.getRange();
            int index = 0;
            for (int i = 0; i < range.numParagraphs(); ++i) {
                WordParagraphInfo info;
                Paragraph p = range.getParagraph(i);
                int titleLevel = p.getLvl();
                String text = this.getMarkedUnDeleted(p);
                if (p.isInTable()) {
                    if (i != 0 && range.getParagraph(i - 1).isInTable()) continue;
                    info = new WordTableInfo();
                    elementInfos.add((WordElementInfo)info);
                    result.getTableInfos().add(info);
                    info.setType("table");
                    info.setPoiIndex(Integer.valueOf(i));
                    info.setIndex(Integer.valueOf(index));
                    ++index;
                    this.assembleTable((WordTableInfo)info, range.getTable(p));
                    continue;
                }
                info = new WordParagraphInfo();
                elementInfos.add((WordElementInfo)info);
                info.setType("para");
                info.setIndex(Integer.valueOf(index));
                info.setPoiIndex(Integer.valueOf(i));
                info.setText(DocRegularEnum.matchCatalog((String)text));
                ++index;
                if (titleLevel == 9 || !StringUtils.isNotEmpty((CharSequence)text)) continue;
                WordChapterInfo chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(text);
                chapterInfo.setLevel(Integer.valueOf(titleLevel));
                chapterInfo.setStartIndex(Integer.valueOf(index));
                chapterInfos.add(chapterInfo);
            }
            this.assembleChapter(chapterInfos, elementInfos);
        }
        catch (IOException e) {
            log.error("doc\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return result;
    }

    private void assembleChapter(List<WordChapterInfo> chapterInfos, List<WordElementInfo> elementInfos) {
        block0: for (int i = 0; i < chapterInfos.size() - 1; ++i) {
            for (int j = i + 1; j < chapterInfos.size(); ++j) {
                WordChapterInfo current = chapterInfos.get(i);
                WordChapterInfo next = chapterInfos.get(j);
                if (next.getLevel() <= current.getLevel()) {
                    current.setEndIndex(next.getStartIndex());
                    continue block0;
                }
                if (j != chapterInfos.size() - 1) continue;
                current.setEndIndex(Integer.valueOf(elementInfos.size()));
                continue block0;
            }
        }
        if (CollectionUtil.isNotEmpty(chapterInfos)) {
            chapterInfos.get(chapterInfos.size() - 1).setEndIndex(Integer.valueOf(elementInfos.size()));
        }
        for (WordChapterInfo chapterInfo : chapterInfos) {
            chapterInfo.setEInfoList(new ArrayList());
            StringBuilder text = new StringBuilder();
            for (int i = chapterInfo.getStartIndex().intValue(); i < chapterInfo.getEndIndex(); ++i) {
                WordElementInfo eInfo = elementInfos.get(i);
                chapterInfo.getEInfoList().add(eInfo);
                if (i <= chapterInfo.getStartIndex()) continue;
                if ("para".equals(eInfo.getType())) {
                    WordParagraphInfo pInfo = (WordParagraphInfo)eInfo;
                    text.append(pInfo.getText()).append("\n");
                    continue;
                }
                if (!"table".equals(eInfo.getType())) continue;
                text.append("\u3010\u8868\u683c\u3011\n");
            }
            chapterInfo.setText(text.toString());
        }
    }

    private void assembleTable(WordTableInfo tInfo, Table table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        tInfo.setRows(rowInfos);
        for (int j = 0; j < table.numRows(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfos.add(rowInfo);
            rowInfo.setIndex(Integer.valueOf(j));
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            TableRow row = table.getRow(j);
            for (int k = 0; k < row.numCells(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfos.add(cellInfo);
                cellInfo.setIndex(Integer.valueOf(k));
                TableCell cell = row.getCell(k);
                cellInfo.setText(cell.text().replaceAll("[\u0007|\\t|\\n|\u00a0+]", "").trim());
                ArrayList<WordParagraphInfo> elementInfos = new ArrayList<WordParagraphInfo>();
                cellInfo.setElementInfos(elementInfos);
                int index = 0;
                for (int l = 0; l < cell.numParagraphs(); ++l) {
                    Paragraph para = cell.getParagraph(l);
                    WordParagraphInfo info = new WordParagraphInfo();
                    elementInfos.add(info);
                    info.setIndex(Integer.valueOf(index));
                    ++index;
                    info.setPoiIndex(Integer.valueOf(l));
                    info.setType("para");
                    info.setText(this.getMarkedUnDeleted(para));
                }
            }
        }
    }

    private List<WordFooter> getFooters(HWPFDocument doc) {
        ArrayList<WordFooter> result = new ArrayList<WordFooter>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordFooter wordFooter = new WordFooter();
            wordFooter.setIndex(Integer.valueOf(i));
            wordFooter.setText(headerStories.getFooter(i));
            result.add(wordFooter);
        }
        return result;
    }

    private List<WordHeader> getHeaders(HWPFDocument doc) {
        ArrayList<WordHeader> result = new ArrayList<WordHeader>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordHeader wordHeader = new WordHeader();
            wordHeader.setIndex(Integer.valueOf(i));
            wordHeader.setText(headerStories.getHeader(i));
            result.add(wordHeader);
        }
        return result;
    }

    private String getMarkedUnDeleted(Paragraph p) {
        StringBuilder pText = new StringBuilder();
        for (int i = 0; i < p.numCharacterRuns(); ++i) {
            CharacterRun run = p.getCharacterRun(i);
            if (run.isMarkedDeleted()) continue;
            pText.append(run.text());
        }
        return pText.toString().trim();
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream("C:\\Users\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\1.5\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u6a21\u677f\\\u65b9\u6848\u5ba1\u67e5\u7eaa\u8981\u6a21\u677f--\u8868\u683c\u9a8c\u8bc1.doc");
        DocStructureUtil util = new DocStructureUtil();
        WordInfo wordInfo = ((WordStructureUtil)util).getWordInfo(inputStream, "\u65b9\u6848\u5ba1\u67e5\u7eaa\u8981\u6a21\u677f--\u8868\u683c\u9a8c\u8bc1.doc");
        System.out.println("-----end-----\u0007\u0007");
    }
}

