/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.word;

import com.jxdinfo.idp.extract.domain.config.word.WordParaConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.util.WordInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordCellInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordElementInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordParagraphInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordRowInfo;
import com.jxdinfo.idp.extract.domain.util.word.WordTableInfo;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Word-\u6bb5\u843d\u63d0\u53d6", order=13)
public class WordParaExtractor
extends AbstractDefaultExtractor<WordInfo, WordParagraphInfo, WordParaConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.WORD_PARA;
    }

    @Override
    public Class<?> outputClass() {
        return WordParagraphInfo.class;
    }

    @Override
    public ExtractorCarrier<WordParagraphInfo> outPut(List<WordInfo> wordInfos, WordParaConfig config) {
        ExtractorCarrier carrier = this.carrier(new ArrayList(), new ArrayList<Location>());
        for (WordInfo wordInfo : wordInfos) {
            for (WordTableInfo tableInfo : wordInfo.getTableInfos()) {
                for (WordRowInfo row : tableInfo.getRows()) {
                    for (WordCellInfo cell : row.getCells()) {
                        this.match(carrier, cell.getElementInfos(), config);
                    }
                }
            }
            this.match(carrier, wordInfo.getElementInfos(), config);
        }
        return carrier.toJsonList();
    }

    private void match(ExtractorCarrier<WordParagraphInfo> carrier, List<WordElementInfo> elementInfos, WordParaConfig config) {
        for (WordElementInfo elementInfo : elementInfos) {
            if (!"para".equals(elementInfo.getType())) continue;
            WordParagraphInfo paraInfo = (WordParagraphInfo)elementInfo;
            Pattern pattern = Pattern.compile(config.getRegex());
            Matcher m = pattern.matcher(paraInfo.getText());
            if (!m.find()) continue;
            carrier.getData().add(paraInfo);
            carrier.getLocations().add(new Location(paraInfo.getText()));
        }
    }
}

