/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.word;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.domain.config.word.WordInfoConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.util.WordInfo;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.extract.util.ReadWordUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Word-\u4fe1\u606f\u63d0\u53d6", order=11)
public class WordInfoExtractor
extends AbstractDefaultExtractor<FileBytesInfo, WordInfo, WordInfoConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.WORD_INFO;
    }

    @Override
    public Class<?> outputClass() {
        return WordInfo.class;
    }

    @Override
    public ExtractorCarrier<WordInfo> outPut(List<FileBytesInfo> input, WordInfoConfig config) {
        ArrayList<WordInfo> output = new ArrayList<WordInfo>();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (FileBytesInfo bytesInfo : input) {
            output.add(ReadWordUtil.getWordInfo(bytesInfo));
            locations.add(new Location());
        }
        return this.carrier(output, locations);
    }
}

