/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.nlp;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.extract.domain.config.nlp.NlpConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.GPTPackagingParamDTO;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.Knowledge;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.extract.thirdpartapi.LargeModelServer;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
@Extractor(group=ExtractorGroupEnum.NLP, name="\u8bed\u4e49\u7406\u89e3", order=26)
public class NlpExtractor
extends AbstractDefaultExtractor<FileBytesInfo, String, NlpConfig> {
    private static final Logger log = LoggerFactory.getLogger(NlpExtractor.class);
    @Autowired
    private LargeModelServer server;

    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.NlP;
    }

    @Override
    protected Class<?> outputClass() {
        return String.class;
    }

    @Override
    protected CategoryDto categoryDto() {
        return this.stringCategoryDto();
    }

    @Override
    protected List<String> extract(List<FileBytesInfo> input, NlpConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(300000L));
        String kName = IdUtils.fastSimpleUUID();
        Knowledge knowledge = new Knowledge(kName);
        knowledge.setTop_k(config.getTopK());
        knowledge.setKeyword(config.getKeyword());
        boolean flag = false;
        for (FileBytesInfo bytesInfo : input) {
            try {
                this.server.createKnowledgeBase(knowledge);
                this.server.uploadDoc(kName, bytesInfo);
            }
            catch (Exception e) {
                flag = true;
            }
            if (flag) {
                result.add("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                continue;
            }
            try {
                GPTPackagingParamDTO param = new GPTPackagingParamDTO();
                param.setAskTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                String answer = this.server.knowledgeBaseChat(knowledge);
                if (!StringUtils.isEmpty((Object)config.getRegex())) {
                    List<String> match = MatchTextUtil.match(config.getRegex(), answer);
                    StringBuilder answerAfter = new StringBuilder();
                    for (int i = 0; i < match.size(); ++i) {
                        answerAfter.append(match.get(i));
                        if (i == match.size() - 1) continue;
                        answerAfter.append(" ");
                    }
                    result.add(answerAfter.toString());
                    continue;
                }
                result.add(answer);
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
                result.add("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
            }
        }
        try {
            this.server.deleteKnowledgeBase(knowledge);
        }
        catch (Exception e) {
            log.error("\u5220\u9664", (Throwable)e);
        }
        return result;
    }

    @Override
    public ExtractorCarrier<String> outPut(List<FileBytesInfo> input, NlpConfig config) {
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<Location> locations = new ArrayList<Location>();
        String kName = IdUtils.fastSimpleUUID();
        Knowledge knowledge = new Knowledge(kName);
        knowledge.setTop_k(config.getTopK());
        knowledge.setKeyword(config.getKeyword());
        boolean flag = false;
        for (FileBytesInfo bytesInfo : input) {
            try {
                this.server.createKnowledgeBase(knowledge);
                this.server.uploadDoc(kName, bytesInfo);
            }
            catch (Exception e) {
                flag = true;
            }
            if (flag) {
                data.add("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                locations.add(new Location());
                continue;
            }
            try {
                GPTPackagingParamDTO param = new GPTPackagingParamDTO();
                param.setAskTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                String answer = this.server.knowledgeBaseChat(knowledge);
                if (!StringUtils.isEmpty((Object)config.getRegex())) {
                    List<String> match = MatchTextUtil.match(config.getRegex(), answer);
                    StringBuilder answerAfter = new StringBuilder();
                    for (int i = 0; i < match.size(); ++i) {
                        answerAfter.append(match.get(i));
                        if (i == match.size() - 1) continue;
                        answerAfter.append(" ");
                    }
                    data.add(answerAfter.toString());
                } else {
                    data.add(answer);
                }
                locations.add(new Location(answer));
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
                data.add("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                locations.add(new Location());
            }
        }
        return this.carrier(data, locations);
    }
}

