/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.extract.domain.config.api.ApiConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.util.api.ApiInfo;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Extractor(group=ExtractorGroupEnum.API, name="API\u63d0\u53d6", order=1)
public class ApiExtractor
extends AbstractDefaultExtractor<Object, ApiInfo, ApiConfig> {
    @Override
    protected List<ApiInfo> extract(List<Object> input, ApiConfig config) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)config.getContentType())) {
            headers.set("Content-Type", config.getContentType());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getHeaders())) {
            JSONObject jsonObject = JSON.parseObject((String)config.getHeaders());
            jsonObject.forEach((key, value) -> headers.set(key, value.toString()));
        }
        HttpMethod httpMethod = HttpMethod.GET;
        String methodType = config.getMethod();
        if (methodType != null && HttpMethod.POST.name().equals(methodType.toUpperCase(Locale.ROOT))) {
            httpMethod = HttpMethod.POST;
        }
        HttpEntity httpEntity = new HttpEntity((Object)config.getBody(), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(config.getUrl(), httpMethod, httpEntity, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        ArrayList<ApiInfo> result = new ArrayList<ApiInfo>();
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setBody(body);
        result.add(apiInfo);
        return result;
    }

    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.API;
    }

    @Override
    public Class<?> outputClass() {
        return ApiInfo.class;
    }

    @Override
    public ExtractorCarrier<ApiInfo> outPut(List<Object> input, ApiConfig config) {
        return this.carrier(this.extract(input, config), new ArrayList<Location>());
    }
}

