/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults;

import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.extract.annotation.AttributeAnnotation;
import com.jxdinfo.idp.extract.annotation.CategoryAnnotation;
import com.jxdinfo.idp.extract.domain.config.DefaultConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.extractor.defaults.IDefaultExtractor;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import com.jxdinfo.idp.model.base.po.Attribute;
import com.jxdinfo.idp.model.base.po.CategoryGroup;
import com.jxdinfo.idp.model.enums.CategoryGroupEnum;
import com.jxdinfo.idp.model.enums.CategoryTypeEnum;
import com.jxdinfo.idp.model.service.ICategoryGroupService;
import com.jxdinfo.idp.model.service.ICategoryService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;

public abstract class AbstractDefaultExtractor<I, O, C extends DefaultConfig>
extends AbstractExtractor<I, O, C>
implements IDefaultExtractor<I, O, C>,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractDefaultExtractor.class);
    @Autowired
    private ICategoryService categoryService;
    @Autowired
    private ICategoryGroupService categoryGroupService;

    @Override
    public String key() {
        return this.extractorEnum().getCode();
    }

    protected abstract Class<?> outputClass();

    protected CategoryDto categoryDto() {
        return this.categoryDto(this.outputClass());
    }

    protected CategoryDto stringCategoryDto() {
        CategoryGroup defaultGroup = this.categoryGroupService.defaultGroup();
        CategoryDto dto = new CategoryDto(this.extractorEnum().getCategoryId(), "0", defaultGroup.getId());
        dto.setDescription("\u7531\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
        dto.setName("\u5b57\u7b26\u6a21\u578b");
        dto.setAttributeList(new ArrayList());
        dto.getAttributeList().add(new Attribute(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()), dto.getId(), "value", "value", CategoryGroupEnum.OBJECT.getCode(), CategoryTypeEnum.TEXT.getCode()));
        return dto;
    }

    public void run(String ... args) {
        CategoryDto categoryDto = this.categoryDto();
        if (categoryDto != null) {
            this.categoryService.add(categoryDto);
        }
    }

    protected ExtractorCarrier<O> carrier(List<O> data, List<Location> locations) {
        return new ExtractorCarrier(this.extractorEnum().getCategoryId(), data, locations);
    }

    protected CategoryDto categoryDto(Class<?> outputClass) {
        CategoryGroup defaultGroup = this.categoryGroupService.defaultGroup();
        CategoryDto dto = new CategoryDto(this.extractorEnum().getCategoryId(), "0", defaultGroup.getId());
        dto.setDescription("\u7531\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
        CategoryAnnotation annotation = outputClass.getDeclaredAnnotation(CategoryAnnotation.class);
        dto.setName(annotation == null ? outputClass.getSimpleName() : annotation.name());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        dto.setAttributeList(attributes);
        for (Field field : outputClass.getDeclaredFields()) {
            Attribute attribute = new Attribute();
            attribute.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
            AttributeAnnotation attributeAnnotation = field.getAnnotation(AttributeAnnotation.class);
            attribute.setName(attributeAnnotation == null ? field.getName() : attributeAnnotation.name());
            attribute.setCode(field.getName());
            attribute.setCategoryId(dto.getId());
            this.handleAttrType(field, attribute);
            attributes.add(attribute);
        }
        return dto;
    }

    private Class<?> handleAttrType(Field field, Attribute attribute) {
        Class<?> fieldClass = null;
        if (List.class.equals(field.getType())) {
            attribute.setGrouping(CategoryGroupEnum.LIST.getCode());
        } else {
            fieldClass = field.getType();
            attribute.setGrouping(CategoryGroupEnum.OBJECT.getCode());
        }
        if (String.class.equals(fieldClass)) {
            attribute.setType(CategoryTypeEnum.TEXT.getCode());
        } else if (Short.class.equals(fieldClass) || Integer.class.equals(fieldClass) || Long.class.equals(fieldClass) || Double.class.equals(fieldClass) || Float.class.equals(fieldClass)) {
            attribute.setType(CategoryTypeEnum.NUMBER.getCode());
        } else {
            attribute.setType(CategoryTypeEnum.MODEL.getCode());
        }
        return fieldClass;
    }
}

