/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.component;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.chain.component.AbstractComponent;
import com.jxdinfo.idp.extract.chain.dto.ResultDataAttribute;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.extract.chain.service.IResultDataCategoryService;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.rule.FlowChainUtils;
import com.jxdinfo.liteflow.annotation.LiteflowComponent;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@LiteflowComponent(id="aggregation", name="\u5408\u5e76\u7ec4\u4ef6")
public class AggregationComponent
extends AbstractComponent {
    private final LFLog logger = LFLoggerManager.getLogger(AggregationComponent.class);
    @Resource
    private IResultDataCategoryService resultDataCategoryService;

    public List executeProcess() {
        Map<String, List<JSONObject>> jsonInput = this.getJsonInput();
        IdpFlowTag idpFlowTag = this.getIdpFlowTag();
        if (idpFlowTag == null) {
            throw new BusinessException("\u8282\u70b9\u6570\u636e\u4e3a\u7a7a");
        }
        Long categoryId = idpFlowTag.getCategoryId();
        if (categoryId == null) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u8282\u70b9{}\u6a21\u578b\u672a\u914d\u7f6e", (Object[])new Object[]{idpFlowTag.getName()}));
        }
        ResultDataCategory resultDataCategory = this.resultDataCategoryService.getResultDataCategory(FlowChainUtils.getChainId((String)this.getChainId()), categoryId);
        List attributes = resultDataCategory.getAttributeList();
        if (CollectionUtils.isEmpty((Collection)attributes)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u8282\u70b9{}\u6a21\u578b{}\u7684\u5c5e\u6027\u4e3a\u7a7a", (Object[])new Object[]{idpFlowTag.getName(), resultDataCategory.getName()}));
        }
        return AggregationComponent.oneToOne(jsonInput, attributes);
    }

    private static List<JSONObject> oneToOne(Map<String, List<JSONObject>> jsonInput, List<ResultDataAttribute> attributes) {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        for (ResultDataAttribute attribute : attributes) {
            List<JSONObject> jsonObjects;
            if (attribute.getNodeId() == null || !StringUtils.isNotBlank((CharSequence)attribute.getNodeKey()) || !CollectionUtils.isNotEmpty(jsonObjects = jsonInput.get(attribute.getNodeId()))) continue;
            for (int i = 0; i < jsonObjects.size(); ++i) {
                if (results.size() <= i) {
                    results.add(new JSONObject());
                }
                ((JSONObject)results.get(i)).put(attribute.getCode(), jsonObjects.get(i).get((Object)attribute.getNodeKey()));
            }
        }
        return results;
    }

    public static void main(String[] args) {
        AggregationComponent.test();
    }

    private static void test() {
        HashMap<String, List<JSONObject>> jsonInput = new HashMap<String, List<JSONObject>>();
        ArrayList<JSONObject> l1 = new ArrayList<JSONObject>();
        JSONObject o1 = new JSONObject();
        o1.put("a1", (Object)"1");
        o1.put("a2", (Object)"2");
        o1.put("a3", (Object)"3");
        l1.add(o1);
        JSONObject o2 = new JSONObject();
        o2.put("a1", (Object)"11");
        o2.put("a2", (Object)"22");
        o2.put("a3", (Object)"33");
        l1.add(o2);
        jsonInput.put("1", l1);
        ArrayList<JSONObject> l2 = new ArrayList<JSONObject>();
        JSONObject o3 = new JSONObject();
        o3.put("b1", (Object)"1");
        o3.put("b2", (Object)"2");
        o3.put("b3", (Object)"3");
        l2.add(o3);
        JSONObject o4 = new JSONObject();
        o4.put("b1", (Object)"11");
        o4.put("b2", (Object)"22");
        o4.put("b3", (Object)"33");
        l2.add(o4);
        jsonInput.put("2", l2);
        ArrayList<ResultDataAttribute> attributes = new ArrayList<ResultDataAttribute>();
        ResultDataAttribute a1 = new ResultDataAttribute();
        a1.setNodeId("1");
        a1.setNodeKey("a1");
        a1.setCode("a1");
        attributes.add(a1);
        ResultDataAttribute a2 = new ResultDataAttribute();
        a2.setNodeId("2");
        a2.setNodeKey("b1");
        a2.setCode("b1");
        attributes.add(a2);
        System.out.println(jsonInput);
        System.out.println(attributes);
        List<JSONObject> result = AggregationComponent.oneToOne(jsonInput, attributes);
        System.out.println(result);
    }
}

