/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.extract.domain.po.ExtractGroupRel;
import com.jxdinfo.idp.extract.mapper.ExtractGroupRelevancyMapper;
import com.jxdinfo.idp.extract.service.IExtractGroupRelService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractGroupRelServiceImpl
extends ServiceImpl<ExtractGroupRelevancyMapper, ExtractGroupRel>
implements IExtractGroupRelService {
    @Autowired
    private ExtractGroupRelevancyMapper mapper;

    @Override
    public void insertRel(Long pid, Long cid) {
        ExtractGroupRel newRel = new ExtractGroupRel(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()), pid, cid, 1);
        if (pid == null) {
            return;
        }
        ArrayList<ExtractGroupRel> rels = new ArrayList<ExtractGroupRel>();
        LambdaQueryWrapper listWrapper = new LambdaQueryWrapper();
        listWrapper.eq(ExtractGroupRel::getCid, (Object)pid);
        List list = this.list((Wrapper)listWrapper);
        for (ExtractGroupRel rel : list) {
            rels.add(new ExtractGroupRel(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()), rel.getPid(), cid, rel.getDistance() + 1));
        }
        rels.add(newRel);
        this.saveBatch(rels);
    }

    @Override
    public void deleteByPid(List<Long> pids) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (CollUtil.isNotEmpty(pids)) {
            wrapper.in(ExtractGroupRel::getPid, pids);
            wrapper.in(ExtractGroupRel::getCid, pids);
            this.remove((Wrapper)wrapper);
        }
    }

    @Override
    public void deleteByPid(Long pid) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ExtractGroupRel::getPid, (Object)pid)).or()).eq(ExtractGroupRel::getCid, (Object)pid);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public List<ExtractGroupRel> getByPid(Long pid) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ExtractGroupRel::getPid, (Object)pid);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void changeGroup(Long pid, Long cid) {
        List<ExtractGroupRel> rels = this.mapper.getRelsById(cid);
        rels.forEach(rel -> rel.setPid(pid));
        this.updateBatchById(rels);
    }
}

