/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.interf.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.container.ExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.extractor.old.IExtractor;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractCoreImpl
implements IExtractCore {
    @Autowired
    private IExtractItemService itemService;
    @Autowired
    private IExtractCoreService extractCoreService;

    public List<ExtractRecord> execute(List<ExtractItemDto> itemDtoList, FileBytesInfo bytesInfo) {
        IExtractor extractor = ExtractorContainer.get("fileExtractor");
        return extractor.execute(itemDtoList, bytesInfo);
    }

    public List<ExtractItemDto> getExtractItemList(ExtractItemQuery queryVo) {
        return this.itemService.getDtoList(queryVo);
    }

    public List<ExtractItemDto> getExtractItemsByIds(List<Long> ids) {
        ExtractItemQuery query = new ExtractItemQuery();
        query.setIds(ids);
        return this.getExtractItemList(query);
    }

    public ExtractItem findById(long itemId) {
        return (ExtractItem)this.itemService.getById(Long.valueOf(itemId));
    }

    public long save(ExtractItem extractItem) {
        return this.extractCoreService.insert(extractItem);
    }
}

