/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.word;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.word.WordTextFromParaConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.word.WordParagraphInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WordTextFromParaExtractor
extends AbstractExtractor<WordParagraphInfo, String, WordTextFromParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.WORD_PARA.getCode(), ExtractorEnum.WORD_TEXT.getCode());
    }

    @Override
    public List<String> extract(List<WordParagraphInfo> paraInfos, WordTextFromParaConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        List<WordParagraphInfo> paragraphInfos = this.targetParas(paraInfos, config);
        for (WordParagraphInfo para : paragraphInfos) {
            result.addAll(MatchTextUtil.match(config.getRegex(), para.getText()));
        }
        return result;
    }

    private List<WordParagraphInfo> targetParas(List<WordParagraphInfo> paraInfos, WordTextFromParaConfig config) {
        ArrayList<WordParagraphInfo> result = new ArrayList<WordParagraphInfo>();
        for (WordParagraphInfo paraInfo : paraInfos) {
            if (!MatchTextUtil.isMatch(config.getParaRegex(), paraInfo.getText()).booleanValue()) continue;
            result.add(paraInfo);
        }
        return result;
    }
}

