/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.word;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.Config;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.ReadWordUtil;
import com.jxdinfo.idp.extract.util.entity.WordInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WordInfoExtractor
extends AbstractExtractor<FileBytesInfo, WordInfo, Config> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.FILE_BYTES_INFO.getCode(), ExtractorEnum.WORD_INFO.getCode());
    }

    @Override
    public List<WordInfo> extract(List<FileBytesInfo> inputs, Config config) {
        ArrayList<WordInfo> result = new ArrayList<WordInfo>();
        for (FileBytesInfo input : inputs) {
            result.add(ReadWordUtil.getWordInfo(input));
        }
        return result;
    }

    @Override
    public List<WordInfo> after(List<WordInfo> outputs, Config config) {
        return outputs;
    }
}

