/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.old.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfig.nlp.NlpConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.GPTPackagingParamDTO;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.Knowledge;
import com.jxdinfo.idp.extract.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractor.old.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.thirdpartapi.LargeModelServer;
import com.jxdinfo.idp.extract.thirdpartapi.NLPParseServer;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class NlpItemExtractor
extends AbstractItemExtractor<FileBytesInfo, FileBytesInfo> {
    private static final Logger log = LoggerFactory.getLogger(NlpItemExtractor.class);
    @Autowired
    private LargeModelServer server;
    @Autowired
    private NLPParseServer seeServer;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.NLP.getImplCode(), ItemExtractorEnum.NLP.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo bytesInfo) {
        return bytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(300000L));
        String kName = IdUtils.fastSimpleUUID();
        Knowledge knowledge = new Knowledge(kName);
        knowledge.setTop_k("3");
        boolean flag = false;
        try {
            this.server.createKnowledgeBase(knowledge);
            this.server.uploadDoc(kName, bytesInfo);
        }
        catch (Exception e) {
            flag = true;
        }
        ArrayList nlpTypeInfos = new ArrayList();
        for (ExtractItemDto extractItemDto : itemDtoList) {
            List relevancyList = extractItemDto.getTypeInfoList();
            for (ExtractTypeInfo info : relevancyList) {
                info.setExtractItemId(extractItemDto.getId());
            }
            List nlpTypeInfos1 = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.NLP.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            nlpTypeInfos.addAll(nlpTypeInfos1);
        }
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>();
        if (CollUtil.isNotEmpty(nlpTypeInfos)) {
            for (ExtractTypeInfo nlpTypeInfo : nlpTypeInfos) {
                NlpConfig config = (NlpConfig)nlpTypeInfo.extractConfig(NlpConfig.class);
                knowledge.setQuery(config.getQuestion());
                ExtractRecord record = new ExtractRecord();
                record.setItemName(nlpTypeInfo.getName());
                record.setObjectId(nlpTypeInfo.getCode());
                record.setExtractItemId(nlpTypeInfo.getExtractItemId());
                if (flag) {
                    record.setResultObject((Object)"\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                    record.setResult("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                } else {
                    try {
                        GPTPackagingParamDTO param = new GPTPackagingParamDTO();
                        param.setAskTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        String answer = this.server.knowledgeBaseChat(knowledge);
                        if (!StringUtils.isEmpty((Object)config.getRegex())) {
                            List<String> match = MatchTextUtil.match(config.getRegex(), answer);
                            StringBuilder answerAfter = new StringBuilder();
                            for (int i = 0; i < match.size(); ++i) {
                                answerAfter.append(match.get(i));
                                if (i == match.size() - 1) continue;
                                answerAfter.append(" ");
                            }
                            record.setResult(answerAfter.toString());
                            record.setResultObject((Object)answerAfter.toString());
                        } else {
                            record.setResult(answer);
                            record.setResultObject((Object)answer);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
                        record.setResultObject((Object)"\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                        record.setResult("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                    }
                }
                result.add(record);
            }
        }
        try {
            this.server.deleteKnowledgeBase(knowledge);
        }
        catch (Exception exception) {
            log.error("\u5220\u9664", (Throwable)exception);
        }
        return result;
    }
}

