/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.old.impl.confighandler;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfig.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractor.old.impl.confighandler.AbstractConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class OcrSealConfigHandler
extends AbstractConfigHandler<OcrSignConfig, JSONObject> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_SEAL.getCode(), GroupLevel3Enum.OCR_SEAL.getName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public JSONObject handle(OcrSignConfig config) {
        JSONObject result = new JSONObject();
        result.put("element_name", (Object)config.getName());
        result.put("match_method", (Object)"keyword_position");
        result.put("iou_thresh", (Object)config.getIouThresh());
        result.put("detect_page", (Object)config.getTargetPages());
        ArrayList<Object> keyword_position = new ArrayList<Object>();
        result.put("keyword_position", keyword_position);
        keyword_position.add(config.getKeyword());
        keyword_position.add(config.getXOffset());
        keyword_position.add(config.getYOffset());
        keyword_position.add(config.getAreaWidth());
        keyword_position.add(config.getAreaHeight());
        HashMap<String, Map> rects = new HashMap<String, Map>();
        rects.put("anchorRect", config.getAnchorRect());
        rects.put("areaRect", config.getAreaRect());
        result.put("rects", rects);
        return result;
    }
}

