/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.ocr;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.ocr.OcrTextFromTableConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.ocr.Cell;
import com.jxdinfo.idp.extract.util.entity.ocr.OcrTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OcrTextFromTableExtractor
extends AbstractExtractor<OcrTable, String, OcrTextFromTableConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.OCR_TABLE.getCode(), ExtractorEnum.OCR_TEXT.getCode());
    }

    @Override
    public List<String> extract(List<OcrTable> tables, OcrTextFromTableConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (OcrTable table : tables) {
            ArrayList points = new ArrayList();
            List<Cell> cells = table.getCells();
            for (Cell cell : cells) {
                if (!MatchTextUtil.isMatch(config.getCellRegex(), cell.getText()).booleanValue()) continue;
                HashMap<String, Integer> point = new HashMap<String, Integer>();
                point.put("colIndex", cell.getCol_index() + config.getOffsetX());
                point.put("rowIndex", cell.getRow_index() + config.getOffsetY());
                points.add(point);
            }
            Iterator iterator = points.iterator();
            for (Cell cell : cells) {
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    if (!Objects.equals(cell.getCol_index(), next.get("colIndex")) || !Objects.equals(cell.getRow_index(), next.get("rowIndex"))) continue;
                    if (StringUtils.isEmpty((Object)config.getRegex())) {
                        result.add(cell.getText());
                    } else {
                        result.addAll(MatchTextUtil.match(config.getRegex(), cell.getText()));
                    }
                    iterator.remove();
                }
            }
        }
        return result;
    }
}

