/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.ocr;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.ocr.OcrTextFromParaConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.ocr.OcrParagraph;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OcrTextFromParaExtractor
extends AbstractExtractor<OcrParagraph, String, OcrTextFromParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.OCR_PARA.getCode(), ExtractorEnum.OCR_TEXT.getCode());
    }

    @Override
    public List<String> extract(List<OcrParagraph> paragraphs, OcrTextFromParaConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (OcrParagraph paragraph : paragraphs) {
            if (!MatchTextUtil.isMatch(config.getParaRegex(), paragraph.getText()).booleanValue()) continue;
            result.addAll(MatchTextUtil.match(config.getRegex(), paragraph.getText()));
        }
        return result;
    }
}

