/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.ocr;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.ocr.OcrParaConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.OcrInfo;
import com.jxdinfo.idp.extract.util.entity.ocr.OcrParagraph;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OcrParagraphExtractor
extends AbstractExtractor<OcrInfo, OcrParagraph, OcrParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.OCR_INFO.getCode(), ExtractorEnum.OCR_PARA.getCode());
    }

    @Override
    public List<OcrParagraph> extract(List<OcrInfo> ocrInfos, OcrParaConfig config) {
        ArrayList<OcrParagraph> result = new ArrayList<OcrParagraph>();
        for (OcrInfo ocrInfo : ocrInfos) {
            for (OcrParagraph paragraph : ocrInfo.getParagraphs()) {
                if (!MatchTextUtil.isMatch(config.getRegex(), paragraph.getText()).booleanValue()) continue;
                result.add(paragraph);
            }
        }
        return result;
    }
}

