/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.excel;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.excel.ExcelTextConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.excel.ExcelCellInfo;
import com.jxdinfo.idp.extract.util.entity.excel.ExcelSheetInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExcelTextExtractor
extends AbstractExtractor<ExcelSheetInfo, String, ExcelTextConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.EXCEL_SHEET.getCode(), ExtractorEnum.EXCEL_TEXT.getCode());
    }

    @Override
    public List<String> extract(List<ExcelSheetInfo> sheetInfos, ExcelTextConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            ExcelCellInfo[][] cellArray2D = sheetInfo.getCellArray2D();
            for (int y = 0; y < cellArray2D.length; ++y) {
                for (int x = 0; x < cellArray2D[y].length; ++x) {
                    ExcelCellInfo cellInfo = cellArray2D[y][x];
                    if (!MatchTextUtil.isMatch(config.getBasicRegex(), cellInfo.getValueStr()).booleanValue()) continue;
                    try {
                        ExcelCellInfo target = cellArray2D[y + config.getOffsetY()][x + config.getOffsetX()];
                        result.addAll(MatchTextUtil.match(config.getRegex(), target.getValueStr()));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }
}

