/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.excel;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.excel.ExcelSheetConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.ExcelInfo;
import com.jxdinfo.idp.extract.util.entity.excel.ExcelSheetInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExcelSheetExtractor
extends AbstractExtractor<ExcelInfo, ExcelSheetInfo, ExcelSheetConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.EXCEL_INFO.getCode(), ExtractorEnum.EXCEL_SHEET.getCode());
    }

    @Override
    public List<ExcelSheetInfo> extract(List<ExcelInfo> excelInfos, ExcelSheetConfig config) {
        ArrayList<ExcelSheetInfo> result = new ArrayList<ExcelSheetInfo>();
        for (ExcelInfo excelInfo : excelInfos) {
            for (ExcelSheetInfo sheetInfo : excelInfo.getSheetInfos()) {
                if (!MatchTextUtil.isMatch(config.getRegex(), sheetInfo.getName()).booleanValue()) continue;
                result.add(sheetInfo);
            }
        }
        return result;
    }
}

