/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.extract.domain.dto.ExtractGroupDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractNode;
import com.jxdinfo.idp.extract.domain.dto.ExtractTypeDtoOld;
import com.jxdinfo.idp.extract.domain.po.ExtractGroup;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractGroupQuery;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/extractCore"})
public class ExtractCoreController {
    @Autowired
    private IExtractCoreService service;

    @GetMapping(value={"/getTree"})
    public ApiResponse<List<ExtractGroupDto>> getTree() {
        return ApiResponse.success(this.service.getTree());
    }

    @PostMapping(value={"/getGroupTree"})
    public ApiResponse<List<ExtractNode>> getTree(@RequestBody ExtractGroupQuery query) {
        return ApiResponse.success(this.service.getTree(query));
    }

    @PostMapping(value={"/getItemList"})
    public ApiResponse<List<ExtractItem>> getItemList(@RequestBody ExtractItemQuery query) {
        return ApiResponse.success(this.service.getItemList(query));
    }

    @PostMapping(value={"/insertGroup"})
    public ApiResponse<ExtractGroup> insertGroup(@RequestBody ExtractGroupDto dto) {
        return ApiResponse.success((Object)this.service.insertGroup(dto));
    }

    @PostMapping(value={"/updateGroup"})
    public ApiResponse<Void> updateGroup(@RequestBody ExtractGroupDto dto) {
        try {
            this.service.updateGroup(dto);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteGroup"})
    public ApiResponse<Void> deleteGroup(@RequestParam(value="id") Long id) {
        try {
            this.service.deleteGroup(id);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<Long> insert(@RequestBody ExtractItem item) {
        return ApiResponse.success((Object)this.service.insert(item));
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody ExtractItem item) {
        this.service.update(item);
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchDelete"})
    public ApiResponse<Void> batchDelete(@RequestBody List<Long> ids) {
        this.service.batchDelete(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getDetail"})
    public ApiResponse<ExtractItemDto> getDetail(Long itemId) {
        return ApiResponse.success((Object)this.service.getItemDto(itemId));
    }

    @GetMapping(value={"/getReturnTypes"})
    public ApiResponse<List<Map<String, String>>> getReturnTypes() {
        return ApiResponse.success(this.service.getReturnTypes());
    }

    @GetMapping(value={"/getExtractTypeList"})
    public ApiResponse<List<ExtractTypeDtoOld>> getExtractTypeList() {
        return ApiResponse.success(this.service.getExtractTypeList());
    }

    @PostMapping(value={"/saveConfig"})
    public ApiResponse<Void> saveConfig(@RequestBody ExtractItemDto dto) {
        this.service.update(dto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/extractTest"})
    public ApiResponse<List<ExtractRecord>> extractTest(ExtractItemQuery query) throws IOException {
        return ApiResponse.success(this.service.extractTest(query));
    }

    @GetMapping(value={"/itemStatistics"})
    public ApiResponse<Long> itemStatistics() {
        return ApiResponse.success((Object)this.service.itemStatistics());
    }

    @PostMapping(value={"/test"})
    public List<ExtractRecord> test(@RequestParam(value="itemId") Long itemId, @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.service.test(itemId, file);
    }
}

