/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.thirdpartapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.http.RequestHTTPUtil;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.BatchAnswer;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.BatchQuestion;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.Knowledge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class LargeModelServer {
    private static final Logger log = LoggerFactory.getLogger(LargeModelServer.class);
    @Value(value="${rmi.largeModel.url}")
    private String url;

    public ApiResponse createKnowledgeBase(Knowledge knowledge) {
        return (ApiResponse)RequestHTTPUtil.requestPost((String)(this.url + "/knowledge_base/create_knowledge_base"), (Object)knowledge, ApiResponse.class);
    }

    public ApiResponse uploadDoc(String knowledge_base_name, final FileBytesInfo bytesInfo) {
        ByteArrayResource file = null;
        try {
            file = new ByteArrayResource(bytesInfo.getFileBytes()){

                public String getFilename() {
                    return bytesInfo.getFileName();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"knowledge_base_name", (Object)knowledge_base_name);
        form.add((Object)"file", (Object)file);
        form.add((Object)"chunk_size", (Object)200);
        form.add((Object)"overlap_size", (Object)30);
        return (ApiResponse)RequestHTTPUtil.requestPost((String)(this.url + "/knowledge_base/upload_doc"), ApiResponse.class, (MultiValueMap)form);
    }

    public ApiResponse deleteDoc(Knowledge knowledge) {
        return (ApiResponse)RequestHTTPUtil.requestPost((String)(this.url + "/knowledge_base/delete_doc"), (Object)knowledge, ApiResponse.class);
    }

    public ApiResponse deleteKnowledgeBase(Knowledge knowledge) {
        return (ApiResponse)RequestHTTPUtil.requestPost((String)(this.url + "/knowledge_base/delete_knowledge_base"), (Object)knowledge, ApiResponse.class);
    }

    public String knowledgeBaseChat(Knowledge knowledge) {
        try {
            String batchAnswer = (String)RequestHTTPUtil.requestPost((String)(this.url + "/chat/knowledge_base_chat"), (Object)knowledge, String.class);
            JSONObject jsonObject = JSON.parseObject((String)batchAnswer);
            return jsonObject.get((Object)"answer").toString();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002";
        }
    }

    BatchAnswer knowledgeBaseChatBatch(BatchQuestion questions) {
        return (BatchAnswer)RequestHTTPUtil.requestPost((String)(this.url + "/chat/knowledge_base_chat_batch"), (Object)questions, BatchAnswer.class);
    }
}

