/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.word;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.word.WordTableConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.WordInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordElementInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WordTableExtractor
extends AbstractExtractor<WordInfo, WordTableInfo, WordTableConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.WORD_INFO.getCode(), ExtractorEnum.WORD_TABLE.getCode());
    }

    @Override
    public List<WordTableInfo> extract(List<WordInfo> wordInfos, WordTableConfig config) {
        ArrayList<WordTableInfo> result = new ArrayList<WordTableInfo>();
        for (WordInfo wordInfo : wordInfos) {
            List<WordElementInfo> elementInfos = wordInfo.getElementInfos();
            for (int i = 0; i < elementInfos.size(); ++i) {
                WordElementInfo wordElementInfo = elementInfos.get(i);
                if (!"para".equals(wordElementInfo.getType())) continue;
                WordParagraphInfo paragraphInfo = (WordParagraphInfo)wordElementInfo;
                if (!MatchTextUtil.matchOld(config.getBasicText(), paragraphInfo.getText())) continue;
                try {
                    WordElementInfo target = elementInfos.get(i + config.getOffset());
                    if (!"table".equals(target.getType())) continue;
                    result.add((WordTableInfo)target);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

