/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.word;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.word.WordParaConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.entity.WordInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordCellInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordElementInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordRowInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class WordParaExtractor
extends AbstractExtractor<WordInfo, WordParagraphInfo, WordParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.WORD_INFO.getCode(), ExtractorEnum.WORD_PARA.getCode());
    }

    @Override
    public List<WordParagraphInfo> extract(List<WordInfo> wordInfos, WordParaConfig config) {
        ArrayList<WordParagraphInfo> result = new ArrayList<WordParagraphInfo>();
        for (WordInfo wordInfo : wordInfos) {
            for (WordTableInfo tableInfo : wordInfo.getTableInfos()) {
                for (WordRowInfo row : tableInfo.getRows()) {
                    for (WordCellInfo cell : row.getCells()) {
                        result.addAll(this.match(cell.getElementInfos(), config));
                    }
                }
            }
            result.addAll(this.match(wordInfo.getElementInfos(), config));
        }
        return result;
    }

    private List<WordParagraphInfo> match(List<WordElementInfo> elementInfos, WordParaConfig config) {
        ArrayList<WordParagraphInfo> result = new ArrayList<WordParagraphInfo>();
        for (WordElementInfo elementInfo : elementInfos) {
            if (!"para".equals(elementInfo.getType())) continue;
            WordParagraphInfo paraInfo = (WordParagraphInfo)elementInfo;
            Pattern pattern = Pattern.compile(config.getRegex());
            Matcher m = pattern.matcher(paraInfo.getText());
            if (!m.find()) continue;
            result.add(paraInfo);
        }
        return result;
    }
}

