/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.word;

import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.word.WordChapterConfig;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.MatchTextUtil;
import com.jxdinfo.idp.extract.util.entity.WordInfo;
import com.jxdinfo.idp.extract.util.entity.word.WordChapterInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WordChapterExtractor
extends AbstractExtractor<WordInfo, WordChapterInfo, WordChapterConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.WORD_INFO.getCode(), ExtractorEnum.WORD_CHAPTER.getCode());
    }

    @Override
    public List<WordChapterInfo> extract(List<WordInfo> wordInfos, WordChapterConfig config) {
        ArrayList<WordChapterInfo> result = new ArrayList<WordChapterInfo>();
        for (WordInfo wordInfo : wordInfos) {
            for (WordChapterInfo chapterInfo : wordInfo.getChapterInfos()) {
                if (!MatchTextUtil.matchOld(config.getChapterName(), chapterInfo.getTitleName())) continue;
                result.add(chapterInfo);
            }
        }
        return result;
    }
}

