/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.old.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractor.old.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.util.ReadWordUtil;
import com.jxdinfo.idp.extract.util.entity.WordInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class WordItemExtractor
extends AbstractItemExtractor<FileBytesInfo, WordInfo> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.WORD.getImplCode(), ItemExtractorEnum.WORD.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public WordInfo before(FileBytesInfo bytesInfo) {
        return ReadWordUtil.getWordInfo(bytesInfo);
    }

    @Override
    public List<ExtractRecord> extract(WordInfo wordInfo, List<ExtractItemDto> itemDtoList) {
        ArrayList<ExtractItemDto> wordItemDtos = new ArrayList<ExtractItemDto>();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List wordTypeRelevancyList = relevancyList.stream().filter(typeInfo -> {
                GroupLevel2Enum groupLevel2Enum = GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum();
                return GroupLevel2Enum.WORD.equals((Object)groupLevel2Enum);
            }).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(wordTypeRelevancyList)) continue;
            dto.setTypeInfoList(wordTypeRelevancyList);
            wordItemDtos.add(dto);
        }
        return super.extract(wordInfo, wordItemDtos);
    }
}

