/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.old.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.extract.container.ChannelExtractorContainer;
import com.jxdinfo.idp.extract.container.ItemExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfig.ExtractConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.enums.ExtractConfigEnum;
import com.jxdinfo.idp.extract.extractor.old.IChannelExtractor;
import com.jxdinfo.idp.extract.extractor.old.IItemExtractor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemExtractor<E, S>
implements IItemExtractor<E, S> {
    private static final Logger log = LoggerFactory.getLogger(AbstractItemExtractor.class);

    @Override
    public void init() {
        ItemExtractorContainer.put(this.implCodeDto().getImplCode(), this);
    }

    @Override
    public List<?> execute(E e, List<ExtractItemDto> itemDtoList) {
        return this.extract(this.before(e), itemDtoList);
    }

    @Override
    public List<ExtractRecord> extract(S s, List<ExtractItemDto> itemDtoList) {
        ArrayList<ExtractRecord> recordList = new ArrayList<ExtractRecord>();
        for (ExtractItemDto dto : itemDtoList) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (ExtractTypeInfo relevancy : dto.getTypeInfoList()) {
                IChannelExtractor channelExtractor = ChannelExtractorContainer.get(relevancy.getExtractType());
                ExtractConfig extractConfig = relevancy.extractConfig(ExtractConfigEnum.extractConfig((String)relevancy.getExtractType()));
                extractConfig.setMatchStrategy(dto.getIntegrationType().intValue());
                Object extractResult = null;
                try {
                    extractResult = channelExtractor.execute(s, extractConfig);
                }
                catch (Exception e) {
                    log.error("\u63d0\u53d6\u9879\u3010" + dto.getName() + "\u3011\u63d0\u53d6\u5f02\u5e38\uff01", (Throwable)e);
                }
                resultList.add(extractResult);
            }
            ExtractRecord record = this.extractRecord(dto);
            this.integration(record, resultList, dto.getIntegrationType(), dto.getExceptionValue());
            recordList.add(record);
        }
        return recordList;
    }

    protected void integration(ExtractRecord record, List<Object> resultList, Integer integrationType, String exceptionValue) {
        if (CollUtil.isNotEmpty(resultList)) {
            Object result = resultList.get(0);
            if (1 == integrationType) {
                result = resultList.get(resultList.size() - 1);
            }
            record.setResult(JSON.toJSONString((Object)result));
            record.setResultObject(result == null ? exceptionValue : result);
        } else {
            record.setResult(exceptionValue);
            record.setResultObject((Object)exceptionValue);
        }
    }

    private ExtractRecord extractRecord(ExtractItemDto itemDto) {
        ExtractRecord record = new ExtractRecord();
        record.setExtractItemId(itemDto.getId());
        record.setItemName(itemDto.getName());
        return record;
    }
}

