/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.ocr;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.Config;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrServer;
import com.jxdinfo.idp.extract.util.entity.OcrInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcrInfoExtractor
extends AbstractExtractor<FileBytesInfo, OcrInfo, Config> {
    @Autowired
    private OcrServer server;

    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.FILE_BYTES_INFO.getCode(), ExtractorEnum.OCR_INFO.getCode());
    }

    @Override
    public List<OcrInfo> extract(List<FileBytesInfo> bytesInfos, Config config) {
        ArrayList<OcrInfo> ocrInfos = new ArrayList<OcrInfo>();
        for (FileBytesInfo bytesInfo : bytesInfos) {
            ocrInfos.add(this.server.getOcrInfo(bytesInfo));
        }
        return ocrInfos;
    }
}

