/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.excel;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.config.Config;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.AbstractExtractor;
import com.jxdinfo.idp.extract.util.ReadExcelUtil;
import com.jxdinfo.idp.extract.util.entity.ExcelInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExcelInfoExtractor
extends AbstractExtractor<FileBytesInfo, ExcelInfo, Config> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.FILE_BYTES_INFO.getCode(), ExtractorEnum.EXCEL_INFO.getCode());
    }

    @Override
    public List<ExcelInfo> extract(List<FileBytesInfo> fileInfos, Config config) {
        ArrayList<ExcelInfo> result = new ArrayList<ExcelInfo>();
        for (FileBytesInfo fileInfo : fileInfos) {
            result.add(ReadExcelUtil.getExcelInfo(fileInfo));
        }
        return result;
    }
}

