/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.core.entity.dto.JsonInfo;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSignInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrSignChannelExtractor")
public class OcrSignExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrSignConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrSignExtractor.class);

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_SIGN.getLevel2Enum().getCode();
    }

    public OcrSignExtractor() {
        OcrSignExtractor a;
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse a, OcrSignConfig a2) {
        TempLocation tempLocation;
        log.info(JsonInfo.short("\u63f2\u5398\u001cp\u8ff9\u512b\u3032\u0001A<q'E g6V<C-V!P`G6V<C-V\u305f"));
        ArrayList<ExtractResult> arrayList = new ArrayList<ExtractResult>();
        if (a == null) {
            return arrayList;
        }
        a2 = (SingleSignInfo)a.getSign().get(a2.getElement_name());
        if (a2 == null) {
            return arrayList;
        }
        TempLocation tempLocation2 = tempLocation = new TempLocation();
        OcrSignConfig ocrSignConfig = a2;
        tempLocation.setPageNum(Integer.valueOf(ocrSignConfig.getPage_id() + 1));
        tempLocation2.setTextBox(ocrSignConfig.getObj_box());
        tempLocation2.setPageInfo((OcrPageInfo)a.getPage_info().get(a2.getPage_id()));
        String string = JSON.toJSONString((Object)a2);
        TempLocation tempLocation3 = tempLocation;
        String string2 = string;
        tempLocation.setContext(string2);
        tempLocation3.setText(string2);
        tempLocation3.setFileId(a.getFileId());
        arrayList.add(new ExtractResult((Object)a2, (Location)tempLocation, ReturnTypeEnum.SING.getKey(), GroupLevel3Enum.OCR_SIGN.getCode()));
        return arrayList;
    }

    @Override
    public void before(ConfigOcrResponse a, OcrSignConfig a2) {
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ReturnTypeEnum.SING.getKey());
        return arrayList;
    }

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_SIGN.getCode(), GroupLevel3Enum.OCR_SIGN.getName(), 2);
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrSignConfig.class;
    }
}

