/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.json.JsonPathExtractor;
import com.jxdinfo.idp.extract.core.entity.dto.JsonInfo;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.json.JsonExtractConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jsonInfoChannelExtractor")
public class JSONExtractor
extends AbstractChannelExtractor<JsonInfo, JsonExtractConfig> {
    private static final Logger log = LoggerFactory.getLogger(JSONExtractor.class);

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.JSON_OBJECT.getLevel2Enum().getCode();
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ReturnTypeEnum.OBJECT.getKey());
        return arrayList;
    }

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.JSON_OBJECT.getCode(), GroupLevel3Enum.JSON_OBJECT.getName(), 1);
    }

    public static Object getNestedValue(JSON a, String a2) {
        int n;
        a2 = a2.split(JsonInfo.short("~`"));
        Object object = a;
        int n2 = a2.length;
        int n3 = n = 0;
        while (n3 < n2) {
            String string = a2[n];
            if (!(object instanceof JSONObject)) {
                return null;
            }
            object = ((JSONObject)object).get((Object)string);
            n3 = ++n;
        }
        return object;
    }

    @Override
    public void before(JsonInfo a, JsonExtractConfig a2) {
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return JsonExtractConfig.class;
    }

    @Override
    public List<ExtractResult> extract(JsonInfo a, JsonExtractConfig a2) {
        log.info(JsonInfo.short("\u639e\u53f4p\u001c\u8f95\u5147\u305eh\u001dm\u0000g6V<C-V!P`G6V<C-V\u305f"));
        ArrayList<ExtractResult> arrayList = new ArrayList<ExtractResult>();
        if (a2.getJsonKey() == null || a2.getJsonKey().trim().isEmpty()) {
            return arrayList;
        }
        a = JsonPathExtractor.extractValue((Object)((JsonInfo)a).getJsonObject(), (String)a2.getJsonKey());
        log.info(JsonInfo.short("H=M \u63f2\u5398\u564a\u305eh\u001dm\u0000g6V<C-V!P`G6V<C-V\u305f\uff2e\u639e\u53f4\u51cb\u5b9b\uff54Y3"), a);
        if (a != null) {
            JSONExtractor a3;
            arrayList.add(new ExtractResult(a, ReturnTypeEnum.OBJECT.getKey(), a3.implCodeDto().getImplCode()));
        }
        return arrayList;
    }

    public JSONExtractor() {
        JSONExtractor a;
    }
}

