/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.llm;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.threepartapi.llm.ILLMChatServe;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.entity.dto.RGTableCellDto;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpChatConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="mllmChannelExtract")
public class MLLMExtractor
extends AbstractChannelExtractor<List<ConfigDocMarkTemplate>, NlpChatConfig> {
    @Autowired
    private ILLMChatServe llmChatServe;
    private static final Logger log = LoggerFactory.getLogger(MLLMExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.NLP_CONTRACT_CHAT.getCode(), GroupLevel3Enum.NLP_CONTRACT_CHAT.getName(), 1);
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return NlpChatConfig.class;
    }

    @Override
    public void before(List<ConfigDocMarkTemplate> a, NlpChatConfig a2) {
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ReturnTypeEnum.STRING.getKey());
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ExtractResult> extract(List<ConfigDocMarkTemplate> a, NlpChatConfig a2) {
        int n;
        int n2;
        ArrayList<String> arrayList;
        log.info(RGTableCellDto.int("\u6381\u53f9o\u0011\u8f8a\u514a\u3041b\u001dc\u001cj)[#N2[>]\u007fJ)[#N2[\u3040"));
        ArrayList<ExtractResult> arrayList2 = new ArrayList<ExtractResult>();
        try {
            arrayList = new ArrayList<String>();
            n2 = a2.getPageNum() > 0 ? a2.getPageNum().intValue() : a.size();
        }
        catch (Exception exception) {
            log.error(RGTableCellDto.int("\u5935\u6a70\u602e\u5976\u6a0e\u57da\u63ff\u5387\u5f2d\u5e69"), (Throwable)exception);
            return arrayList2;
        }
        {
            int n3;
            n = n2;
            n = Math.min(n, a.size());
            int n4 = n3 = 0;
            while (n4 < n) {
                Object e = a.get(n3);
                arrayList.add(((ConfigDocMarkTemplate)e).getImgBase64());
                n4 = ++n3;
            }
        }
        {
            MLLMExtractor a3;
            String string = a3.llmChatServe.llmChatRecall(arrayList, a2.getQuestion());
            log.info(RGTableCellDto.int("\u594b\u6a0e\u6050\u5908\u6a70\u57a4\u549c\u5ebb\uff4bT,"), (Object)string);
            if (!StringUtils.isEmpty((Object)string) && !StringUtils.isEmpty((Object)a2.getRegex())) {
                a = MatchTextUtil.match((String)a2.getRegex(), (String)string);
                a2 = new StringBuilder();
                int n5 = n = 0;
                while (n5 < a.size()) {
                    ((StringBuilder)a2).append((String)a.get(n));
                    if (n != a.size() - 1) {
                        ((StringBuilder)a2).append(RGTableCellDto.int("q"));
                    }
                    n5 = ++n;
                }
                string = ((StringBuilder)a2).toString();
            }
            arrayList2.add(new ExtractResult((Object)string, ReturnTypeEnum.STRING.getKey(), a3.implCodeDto().getImplCode()));
            return arrayList2;
        }
    }

    public MLLMExtractor() {
        MLLMExtractor a;
    }

    @Override
    public String belongExtractorImplCode() {
        return RGTableCellDto.int("B=C<");
    }
}

