/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.util;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdf2ImgUtil {
    private static final Logger log = LoggerFactory.getLogger(Pdf2ImgUtil.class);

    public static int pdf2Image(String pdfFilePath, String dstImgFolder, int dpi) {
        int pages = 1;
        try {
            File file = new File(pdfFilePath);
            if (!file.exists()) {
                throw new BusinessException("can not find file in " + pdfFilePath);
            }
            PDDocument pdDocument = PDDocument.load((File)file);
            int dot = pdfFilePath.lastIndexOf(46);
            int lastSep = pdfFilePath.lastIndexOf(File.separator) + 1;
            String imagePDFName = pdfFilePath.substring(lastSep, dot);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            pages = pdDocument.getNumberOfPages();
            StringBuffer imgFilePath = null;
            for (int i = 0; i < pages; ++i) {
                String imgFilePathPrefix = dstImgFolder + File.separator + imagePDFName;
                imgFilePath = new StringBuffer();
                imgFilePath.append(imgFilePathPrefix);
                imgFilePath.append("_");
                imgFilePath.append(String.valueOf(i + 1));
                imgFilePath.append(".png");
                File dstFile = new File(imgFilePath.toString());
                BufferedImage image = renderer.renderImageWithDPI(i, (float)dpi);
                ImageIO.write((RenderedImage)image, "png", dstFile);
            }
            log.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u6210\u529f\uff01");
        }
        catch (IOException e) {
            log.error("error occured on trans pdf to img", (Throwable)e);
        }
        return pages;
    }

    public static ConfigDocMarkTemplate pdf2Image(FileBytesInfo fileBytesInfo, int dpi, int pageNum) {
        ConfigDocMarkTemplate markTemplate = new ConfigDocMarkTemplate();
        String fileName = fileBytesInfo.getFileName();
        markTemplate.setFileName(fileName);
        byte[] file = fileBytesInfo.getFileBytes();
        if (file == null || file.length == 0) {
            throw new BusinessException("PDF\u6587\u4ef6\u8f6cPNG\u56fe\u7247\u672a\u627e\u5230\u6587\u4ef6");
        }
        try (ByteArrayOutputStream outs = new ByteArrayOutputStream();){
            PDDocument pdDocument = PDDocument.load((byte[])file);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            int pages = pdDocument.getNumberOfPages();
            markTemplate.setTotalPage(Integer.valueOf(pages));
            if (pageNum >= pages) {
                pageNum = 0;
            }
            BufferedImage image = renderer.renderImageWithDPI(pageNum, (float)dpi);
            markTemplate.setWidth(Integer.valueOf(image.getWidth()));
            markTemplate.setHeight(Integer.valueOf(image.getHeight()));
            ImageIO.write((RenderedImage)image, "png", outs);
            outs.flush();
            markTemplate.setImgByte(outs.toByteArray());
            log.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u6210\u529f\uff01");
        }
        catch (IOException | IndexOutOfBoundsException e) {
            log.error("pdf2Image\u6587\u4ef6\u8f6cPNG\u56fe\u7247\uff0c\u6307\u5b9a\u9875\u6570\u5931\u8d25", (Throwable)e);
        }
        return markTemplate;
    }

    public static List<ConfigDocMarkTemplate> pdf2ImageBase64(FileBytesInfo fileBytesInfo, int dpi, List<Integer> pageNums, boolean isNeedBase64Header) {
        PDDocument pdDocument;
        ArrayList<ConfigDocMarkTemplate> markTemplateList = new ArrayList<ConfigDocMarkTemplate>();
        String fileName = fileBytesInfo.getFileName();
        byte[] file = fileBytesInfo.getFileBytes();
        if (file == null || file.length == 0) {
            throw new BusinessException("PDF\u6587\u4ef6\u8f6cPNG\u56fe\u7247\u672a\u627e\u5230\u6587\u4ef6");
        }
        try {
            pdDocument = PDDocument.load((byte[])file);
        }
        catch (IOException e) {
            log.error("pdf2Image\u6587\u4ef6\u8f6cPNG\u56fe\u7247\uff0c\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return markTemplateList;
        }
        PDFRenderer renderer = new PDFRenderer(pdDocument);
        int pages = pdDocument.getNumberOfPages();
        for (Integer pageNum : pageNums) {
            if (pageNum >= pages) break;
            try {
                ByteArrayOutputStream outs = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ConfigDocMarkTemplate markTemplate = new ConfigDocMarkTemplate();
                    markTemplate.setTotalPage(Integer.valueOf(pages));
                    markTemplate.setFileName(fileName);
                    markTemplate.setCurrentPage(pageNum.intValue());
                    BufferedImage image = renderer.renderImageWithDPI(pageNum.intValue(), (float)dpi);
                    markTemplate.setWidth(Integer.valueOf(image.getWidth()));
                    markTemplate.setHeight(Integer.valueOf(image.getHeight()));
                    ImageIO.write((RenderedImage)image, "png", outs);
                    outs.flush();
                    byte[] imageBytes = outs.toByteArray();
                    String base64Image = Base64.getEncoder().encodeToString(imageBytes);
                    if (isNeedBase64Header) {
                        markTemplate.setImgBase64("data:image/png;base64," + base64Image);
                    } else {
                        markTemplate.setImgBase64(base64Image);
                    }
                    markTemplateList.add(markTemplate);
                    log.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u6210\u529f\uff01");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outs == null) continue;
                    if (throwable != null) {
                        try {
                            outs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outs.close();
                }
            }
            catch (IOException | IndexOutOfBoundsException e) {
                log.error("pdf2ImageBase64\u6587\u4ef6\u8f6cPNG\u56fe\u7247\uff0c\u6307\u5b9a\u9875\u6570\u5931\u8d25", (Throwable)e);
            }
        }
        return markTemplateList;
    }
}

