/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.remote;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component(value="ocrExtractServe")
public class OcrConfigServe {
    private static final Logger log = LoggerFactory.getLogger(OcrConfigServe.class);
    @Value(value="${rmi.ocrConfigExtract.url}")
    private String URL;
    @Value(value="${rmi.ocrConfigExtract.api.extract}")
    private String extract;
    @Autowired
    private RestTemplate restTemplate;

    public ConfigOcrResponse ocr(Map config, String fileFormat, byte[] data) {
        try {
            log.info("OCR>>> \u63d0\u53d6\u670d\u52a1\uff1a\u5f00\u59cb\uff01\uff01\uff01");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            String configJsonStr = JSON.toJSONString((Object)config);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"file", (Object)new ByteArrayResource(data){

                public String getFilename() {
                    return System.currentTimeMillis() + ".pdf";
                }
            });
            body.add((Object)"config", (Object)configJsonStr);
            log.info("OCR>>> \u63d0\u53d6\u670d\u52a1\u914d\u7f6econfig\uff1a" + configJsonStr);
            body.add((Object)"attachmentType", (Object)"pdf");
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            log.info("OCR>>> \u63d0\u53d6\u670d\u52a1\uff1aURL:" + this.URL + this.extract);
            ResponseEntity entity = this.restTemplate.postForEntity(this.URL + this.extract, (Object)request, String.class, new Object[0]);
            log.info("OCR>>> \u63d0\u53d6\u670d\u52a1 \u7ed3\u675f\uff01\uff01\uff01");
            return (ConfigOcrResponse)JSON.parseObject((String)((String)entity.getBody()), ConfigOcrResponse.class);
        }
        catch (Exception e) {
            log.error("ocr\u63d0\u53d6\u670d\u52a1\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
    }
}

