/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.type;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.core.api.IExtractor;
import com.jxdinfo.idp.extract.core.api.IMethodExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractExtractor<T, R>
implements IExtractor<T, R>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractExtractor.class);
    protected final Map<String, IMethodExtractor> METHOD_EXTRACTOR_MAP = new LinkedHashMap<String, IMethodExtractor>();
    @Autowired
    private List<IMethodExtractor> methodExtractors;

    public void afterPropertiesSet() {
        if (CollUtil.isNotEmpty(this.methodExtractors)) {
            List extractorsSorted = this.methodExtractors.stream().sorted(Comparator.comparingInt(o -> o.implCodeDto().getSortNum())).collect(Collectors.toList());
            for (IMethodExtractor extractor : extractorsSorted) {
                if (!Objects.equals(extractor.belongExtractorImplCode(), this.implCodeDto().getImplCode())) continue;
                this.METHOD_EXTRACTOR_MAP.put(extractor.implCodeDto().getImplCode(), extractor);
                log.info("\u6ce8\u518c\u63d0\u53d6\u65b9\u5f0f\u6267\u884c\u5668\uff1a{}->{}", (Object)extractor.implCodeDto().getImplName(), (Object)this.implCodeDto().getImplName());
            }
        }
    }

    @Override
    public List<GroupLevel> getExtractorList() {
        ArrayList<GroupLevel> list = new ArrayList<GroupLevel>();
        this.METHOD_EXTRACTOR_MAP.forEach((methodExtractorImplCode, extractor) -> {
            GroupLevel groupLevel = new GroupLevel(extractor.implCodeDto().getImplCode(), extractor.implCodeDto().getImplName());
            groupLevel.setChildren(extractor.getExtractorList());
            list.add(groupLevel);
        });
        return list;
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        return this.METHOD_EXTRACTOR_MAP.values().stream().anyMatch(extractor -> extractor.supportInputParam(info));
    }

    @Override
    public List<ExtractRecord> execute(List<ExtractItemDto> itemList, T info) {
        return this.extract(itemList, this.before(info));
    }

    @Override
    public List<ExtractRecord> extract(List<ExtractItemDto> itemList, R info) {
        HashMap<Long, ExtractRecord> extractResult = new HashMap<Long, ExtractRecord>();
        this.doExtract(itemList, info, extractResult);
        return new ArrayList<ExtractRecord>(extractResult.values());
    }

    private void doExtract(List<ExtractItemDto> itemList, R info, Map<Long, ExtractRecord> extractResult) {
        this.METHOD_EXTRACTOR_MAP.forEach((implCode, extractor) -> {
            ArrayList<ExtractItemDto> extractItemList = new ArrayList<ExtractItemDto>();
            for (ExtractItemDto itemDto : itemList) {
                List infoList = itemDto.getTypeInfoList();
                if (!CollUtil.isNotEmpty((Collection)infoList)) continue;
                List ocrTypeInfos = infoList.stream().filter(typeInfo -> extractor.support(typeInfo.getExtractType())).collect(Collectors.toList());
                ExtractItemDto item = new ExtractItemDto();
                BeanUtil.copyProperties((Object)itemDto, (Object)item, (String[])new String[0]);
                if (!CollUtil.isNotEmpty(ocrTypeInfos) || extractResult.get(itemDto.getId()) != null) continue;
                item.setTypeInfoList(ocrTypeInfos);
                extractItemList.add(item);
            }
            if (CollUtil.isNotEmpty(extractItemList)) {
                try {
                    List<?> resultTem = extractor.execute(info, extractItemList);
                    if (CollUtil.isNotEmpty(resultTem)) {
                        resultTem.forEach(res -> {
                            if (StringUtils.isNotBlank((CharSequence)res.getResult()) && !"\"\"".equals(res.getResult())) {
                                extractResult.put(res.getExtractItemId(), (ExtractRecord)res);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.error("{}\u6267\u884c\u63d0\u53d6\u65b9\u5f0f\u6267\u884c\u5668\u5f02\u5e38\uff1a", (Object)extractor.implCodeDto().getImplCode(), (Object)e);
                }
            }
        });
    }
}

