/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method.parse;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.enums.doc.DocFormat;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.common.util.file.DocumentFormatDetector;
import com.jxdinfo.idp.extract.core.extractor.method.AbstractMethodExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class WordMethodExtractor
extends AbstractMethodExtractor<FileBytesInfo, WordInfo> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel2Enum.WORD.getCode(), GroupLevel2Enum.WORD.getName(), 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel2Enum.WORD.getLevel1Enum().getCode();
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        if (info instanceof FileBytesInfo) {
            DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])((FileBytesInfo)info).getFileBytes(), (String)((FileBytesInfo)info).getFileName());
            return format == DocFormat.DOC || format == DocFormat.DOCX;
        }
        return false;
    }

    @Override
    public WordInfo before(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        WordInfo wordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)bytesInfo);
        wordInfo.setFileId(bytesInfo.getFileId());
        return wordInfo;
    }
}

