/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method.ocr;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.enums.doc.DocFormat;
import com.jxdinfo.idp.common.enums.dto.OcrGenericRequest;
import com.jxdinfo.idp.common.enums.ocr.GenericEnum;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.file.DocumentFormatDetector;
import com.jxdinfo.idp.extract.core.extractor.method.AbstractMethodExtractor;
import com.jxdinfo.idp.extract.core.remote.OcrConfigServe;
import com.jxdinfo.idp.extract.core.remote.OcrGenericText;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageResponse;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.domain.restTemplate.response.OcrApiResponse;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractConfigEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OcrMethodExtractor
extends AbstractMethodExtractor<FileBytesInfo, ConfigOcrResponse> {
    private static final Logger log = LoggerFactory.getLogger(OcrMethodExtractor.class);
    private static final JSONObject config = new JSONObject();
    @Autowired
    private OcrConfigServe ocrConfigServe;
    @Autowired
    private OcrGenericText ocrGenericText;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel2Enum.OCR.getCode(), GroupLevel2Enum.OCR.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel2Enum.OCR.getLevel1Enum().getCode();
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        if (info instanceof FileBytesInfo) {
            DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])((FileBytesInfo)info).getFileBytes(), (String)((FileBytesInfo)info).getFileName());
            return format == DocFormat.PDF || format == DocFormat.JPEG || format == DocFormat.PNG || format == DocFormat.JPG;
        }
        return false;
    }

    @Override
    public ConfigOcrResponse before(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrItemExtractor.extract\u3011" + bytesInfo.getFileName());
        JSONObject rules = new JSONObject();
        JSONObject globalConfig = JSONObject.parseObject((String)config.toJSONString());
        JSONObject globalParamConfig = globalConfig.getJSONObject("global_param");
        JSONObject objectSetting = globalParamConfig.getJSONObject("object_setting");
        ArrayList<OcrTextConfig> texts = new ArrayList<OcrTextConfig>();
        ArrayList<JSONObject> textTablss = new ArrayList<JSONObject>();
        ArrayList<JSONObject> tables = new ArrayList<JSONObject>();
        ArrayList<JSONObject> seals = new ArrayList<JSONObject>();
        ArrayList<JSONObject> signs = new ArrayList<JSONObject>();
        ArrayList<JSONObject> writeDates = new ArrayList<JSONObject>();
        HashMap regexMap = new HashMap();
        boolean isOCRGenericText = false;
        boolean isOCRExtract = false;
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List ocrTypeInfos = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.OCR.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(ocrTypeInfos)) continue;
            for (ExtractTypeInfo info : ocrTypeInfos) {
                int page;
                JSONArray detect_page;
                Object ocrJson;
                Map extractConfig;
                if (info.getExtractConfig() != null) {
                    extractConfig = info.getExtractConfig();
                    info.getExtractConfig().put("element_name", info.getName() + info.getId());
                } else {
                    extractConfig = JSON.parseObject((String)info.getConfig());
                }
                if (GroupLevel3Enum.OCR_SIMPLE.getCode().equals(info.getExtractType())) {
                    OcrTextConfig text = info.getExtractConfig() != null ? (OcrTextConfig)JSONObject.parseObject((String)JSON.toJSONString((Object)info.getExtractConfig()), OcrTextConfig.class) : (OcrTextConfig)info.extractConfig(ExtractConfigEnum.extractConfig((String)info.getExtractType()));
                    if (text != null && text.getFromTabFlag() != null && text.getFromTabFlag().equals("1")) {
                        objectSetting.put("table_det", (Object)true);
                        JSONObject textTable = new JSONObject();
                        textTable.put("table_keywords", (Object)text.getTable_keywords());
                        textTable.put("table_title", (Object)text.getTable_title());
                        String randomKey = SnowFlakeUtil.getFlowIdInstance().nextId() + "";
                        textTable.put("element_name", (Object)randomKey);
                        textTable.put("id", (Object)randomKey);
                        textTable.put("key", (Object)randomKey);
                        textTable.put("handleType", (Object)"definedtab");
                        textTablss.add(textTable);
                        text.setSpecify_table(randomKey);
                        text.setExtract_type("table");
                        text.setTable_keywords(null);
                        text.setCell_pattern(null);
                    } else {
                        text.setPattern(new ArrayList<String>(Collections.singletonList("(.*)")));
                    }
                    text.setId(String.valueOf(info.getId()));
                    text.setKey(info.getName() + info.getId());
                    if (StringUtils.isEmpty((String)text.getIndex_trend())) {
                        text.setIndex_trend("left");
                    }
                    text.setElement_name(info.getName() + info.getId());
                    texts.add(text);
                } else if (GroupLevel3Enum.OCR_SEAL.getCode().equals(info.getExtractType())) {
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject seal = JSON.parseObject((String)ocrJson.toString());
                        detect_page = seal.getJSONArray("detect_page");
                        for (int i = 0; i < detect_page.size(); ++i) {
                            page = detect_page.getInteger(i);
                            if (page < 0) continue;
                            detect_page.set(i, (Object)(page - 1));
                        }
                        seal.put("element_name", (Object)(info.getName() + info.getId()));
                        seals.add(seal);
                    }
                    catch (Exception e) {
                        log.error("\u5370\u7ae0\u914d\u7f6e\u6709\u8bef" + e.getMessage());
                    }
                } else if (GroupLevel3Enum.OCR_SIGN.getCode().equals(info.getExtractType())) {
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject sign = JSON.parseObject((String)ocrJson.toString());
                        detect_page = sign.getJSONArray("detect_page");
                        for (int i = 0; i < detect_page.size(); ++i) {
                            page = detect_page.getInteger(i);
                            if (page < 0) continue;
                            detect_page.set(i, (Object)(page - 1));
                        }
                        sign.put("element_name", (Object)(info.getName() + info.getId()));
                        signs.add(sign);
                    }
                    catch (Exception e) {
                        log.error("\u7b7e\u5b57\u914d\u7f6e\u6709\u8bef" + e.getMessage());
                    }
                } else if (GroupLevel3Enum.OCR_TABLE.getCode().equals(info.getExtractType())) {
                    try {
                        objectSetting.put("table_det", (Object)true);
                        JSONObject table = JSON.parseObject((String)JSON.toJSONString((Object)extractConfig));
                        table.put("element_name", (Object)(info.getName() + info.getId()));
                        tables.add(table);
                    }
                    catch (Exception e) {
                        log.error("\u8868\u683c\u914d\u7f6e\u6709\u8bef" + e.getMessage());
                    }
                } else if (GroupLevel3Enum.OCR_WRITE_DATE.getCode().equals(info.getExtractType())) {
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject ocrJsonJsonObject = JSON.parseObject((String)ocrJson.toString());
                        detect_page = ocrJsonJsonObject.getJSONArray("detect_page");
                        for (int i = 0; i < detect_page.size(); ++i) {
                            page = detect_page.getInteger(i);
                            if (page < 0) continue;
                            detect_page.set(i, (Object)(page - 1));
                        }
                        JSONObject writedate = JSON.parseObject((String)JSON.toJSONString((Object)extractConfig));
                        writedate.put("match_method", ocrJsonJsonObject.get((Object)"match_method"));
                        writedate.put("keyword_position", ocrJsonJsonObject.get((Object)"keyword_position"));
                        writedate.put("directions", ocrJsonJsonObject.get((Object)"directions"));
                        writedate.put("detect_page", ocrJsonJsonObject.get((Object)"detect_page"));
                        writedate.put("iou_thresh", ocrJsonJsonObject.get((Object)"iou_thresh"));
                        writedate.put("ocrJson", (Object)"");
                        writedate.put("element_name", (Object)(info.getName() + info.getId()));
                        writeDates.add(writedate);
                    }
                    catch (Exception e) {
                        log.error("\u624b\u5199\u65e5\u671f\u914d\u7f6e\u6709\u8bef" + e.getMessage());
                    }
                } else if (GroupLevel3Enum.OCR_WRITE_DATE_LIST.getCode().equals(info.getExtractType())) {
                    isOCRGenericText = true;
                } else if (GroupLevel3Enum.OCR_SEAL_LIST.getCode().equals(info.getExtractType())) {
                    objectSetting.put("seal_det", (Object)true);
                    objectSetting.put("seal_det_thresh", (Object)0.5);
                    objectSetting.put("seal_rec", (Object)true);
                    isOCRExtract = true;
                }
                if (info.getExtractConfig() == null) continue;
                info.toConfig();
            }
        }
        if (CollUtil.isNotEmpty(texts)) {
            rules.put("text", texts);
            isOCRExtract = true;
        }
        if (CollUtil.isNotEmpty(textTablss)) {
            rules.put("defined_table", textTablss);
            isOCRExtract = true;
        }
        if (CollUtil.isNotEmpty(seals)) {
            objectSetting.put("seal_det", (Object)true);
            objectSetting.put("seal_det_thresh", (Object)0.5);
            objectSetting.put("seal_rec", (Object)true);
            rules.put("seal", seals);
            isOCRExtract = true;
        }
        if (CollUtil.isNotEmpty(tables)) {
            rules.put("table", tables);
            isOCRExtract = true;
        }
        if (CollUtil.isNotEmpty(signs)) {
            objectSetting.put("sign_det", (Object)true);
            objectSetting.put("sign_det_thresh", (Object)0.5);
            rules.put("sign", signs);
            isOCRExtract = true;
        }
        if (CollUtil.isNotEmpty(writeDates)) {
            objectSetting.put("writedate_det", (Object)true);
            objectSetting.put("writedate_det_thresh", (Object)0.5);
            objectSetting.put("writedate_rec", (Object)true);
            rules.put("writedate", writeDates);
            isOCRExtract = true;
        }
        globalParamConfig.put("object_setting", (Object)objectSetting);
        globalConfig.put("global_param", (Object)globalParamConfig);
        JSONObject globalConfigSetting = this.getConfig(globalConfig, bytesInfo.getGlobalParam());
        globalConfigSetting.put("rules", (Object)rules);
        long startTime = System.currentTimeMillis();
        log.info("OCR>>> \u3010{}\u3011\u63d0\u53d6\u5f00\u59cb\u6267\u884c\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)bytesInfo.getFileName(), (Object)LocalDateTime.now());
        ConfigOcrResponse ocr = null;
        List ocrList = null;
        try {
            if (isOCRExtract) {
                ocr = this.ocrConfigServe.ocr((Map)globalConfigSetting, bytesInfo.getFileFormat(), bytesInfo.getFileBytes());
            }
            if (isOCRGenericText) {
                OcrGenericRequest requestBody = GenericEnum.WRITE_DATE.getOcrGenericRequest();
                requestBody.setFile_type(bytesInfo.getFileFormat());
                MockMultipartFile file = new MockMultipartFile(bytesInfo.getFileName(), bytesInfo.getFileName(), null, bytesInfo.getFileBytes());
                requestBody.setFile((MultipartFile)file);
                OcrApiResponse<List<OcrPageResponse>> responseList = this.ocrGenericText.getOcr(requestBody);
                if (!responseList.isSuccess()) {
                    log.error("OCR\u901a\u7528\u6587\u672c\u8bc6\u522b\u670d\u52a1\u5f02\u5e38" + responseList.getMsg());
                } else {
                    ocrList = (List)responseList.getData();
                    if (CollUtil.isNotEmpty((Collection)ocrList)) {
                        if (ocr == null) {
                            ocr = new ConfigOcrResponse();
                        }
                        ocr.setOcrGenericList(ocrList);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("OCR\u670d\u52a1\u5f02\u5e38,{}", (Object)e.getMessage());
        }
        log.info("OCR\u7b97\u6cd5\u63d0\u53d6\u7ed3\u675f\uff0c\u8017\u65f6{}ms\uff0c\u63d0\u53d6\u7ed3\u679c\uff1a{}", (Object)(System.currentTimeMillis() - startTime), (Object)ocr);
        ocr.setFileId(bytesInfo.getFileId());
        return ocr;
    }

    private JSONObject getConfig(JSONObject globalConfig, String ocrGlobalParam) {
        if (StringUtils.isBlank((CharSequence)ocrGlobalParam)) {
            return globalConfig;
        }
        JSONObject extractConfig = null;
        try {
            extractConfig = JSON.parseObject((String)ocrGlobalParam);
        }
        catch (Exception e) {
            log.error("OCR\u5168\u5c40\u53c2\u6570\u6709\u8bef:{}", (Object)ocrGlobalParam);
        }
        if (extractConfig == null || !extractConfig.containsKey((Object)"ocrConfig")) {
            return globalConfig;
        }
        JSONObject configSetting = extractConfig.getJSONObject("ocrConfig");
        JSONObject globalParamSetting = configSetting.getJSONObject("global_param");
        JSONObject globalParamConfig = globalConfig.getJSONObject("global_param");
        for (Map.Entry entry : globalParamSetting.entrySet()) {
            String key = (String)entry.getKey();
            globalParamConfig.put(key, globalParamSetting.get((Object)key));
        }
        JSONObject objectConfig = globalParamConfig.getJSONObject("object_setting");
        JSONObject objectSetting = globalParamSetting.getJSONObject("object_setting");
        for (Map.Entry entry : objectSetting.entrySet()) {
            String key = (String)entry.getKey();
            objectConfig.put(key, objectSetting.get((Object)key));
        }
        globalParamConfig.put("object_setting", (Object)objectConfig);
        globalConfig.put("global_param", (Object)globalParamConfig);
        return globalConfig;
    }

    static {
        JSONObject globalParam = new JSONObject();
        config.put("global_param", (Object)globalParam);
        globalParam.put("pdf_num", (Object)99);
        globalParam.put("continuous_page_number", (Object)false);
        JSONObject objectSetting = new JSONObject();
        globalParam.put("object_setting", (Object)objectSetting);
        objectSetting.put("seal_det", (Object)false);
        objectSetting.put("seal_det_thresh", (Object)0.5);
        objectSetting.put("sign_det", (Object)false);
        objectSetting.put("sign_det_thresh", (Object)0.5);
        objectSetting.put("writedate_det", (Object)false);
        objectSetting.put("writedate_det_thresh", (Object)0.5);
        objectSetting.put("writedate_rec", (Object)false);
        objectSetting.put("table_det", (Object)false);
        objectSetting.put("seal_elim", (Object)false);
        objectSetting.put("seal_elim_type", (Object)"unet");
        objectSetting.put("watermark_elim", (Object)false);
        objectSetting.put("watermark_elim_thresh", (Object)100);
        objectSetting.put("seal_rec", (Object)false);
    }
}

