/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method.llm;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.threepartapi.rag.Knowledge;
import com.jxdinfo.idp.common.entity.threepartapi.rag.UploadDocForm;
import com.jxdinfo.idp.common.enums.doc.DocFormat;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.threepartapi.rag.IKnowledgeBaseServer;
import com.jxdinfo.idp.common.util.file.DocumentFormatDetector;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.extract.core.api.IChannelExtractor;
import com.jxdinfo.idp.extract.core.extractor.method.AbstractMethodExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpOldConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NlpMethodExtractor
extends AbstractMethodExtractor<FileBytesInfo, Knowledge> {
    private static final Logger log = LoggerFactory.getLogger(NlpMethodExtractor.class);
    @Autowired
    private IKnowledgeBaseServer server;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel2Enum.NLP.getCode(), GroupLevel2Enum.NLP.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel2Enum.NLP.getLevel1Enum().getCode();
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        if (info instanceof FileBytesInfo) {
            DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])((FileBytesInfo)info).getFileBytes(), (String)((FileBytesInfo)info).getFileName());
            return format == DocFormat.PDF || format == DocFormat.DOCX || format == DocFormat.DOC || format == DocFormat.XLSX || format == DocFormat.XLS || format == DocFormat.JPEG || format == DocFormat.PNG || format == DocFormat.JPG;
        }
        return false;
    }

    @Override
    public Knowledge before(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        log.info("NLP>>>\u8fdb\u5165NlpItemExtractor\u7684before\uff0c\u5f00\u59cb\u521b\u5efa\u77e5\u8bc6\u5e93");
        String kName = IdUtils.fastSimpleUUID();
        Knowledge knowledge = new Knowledge(kName);
        ApiResponse knowledgeBase = this.server.createKnowledgeBase(knowledge);
        log.info("NLP>>>\u521b\u5efa\u77e5\u8bc6\u5e93\u5b8c\u6210\uff0ckName:{}", (Object)kName);
        UploadDocForm form = new UploadDocForm();
        form.setKnowledge_base_name(kName);
        form.setBytesInfo(bytesInfo);
        form.setChunk_size(Integer.valueOf(300));
        form.setOverlap_size(Integer.valueOf(50));
        ApiResponse jsonObjectApiResponse = this.server.uploadDoc(form);
        knowledge.setExtractFileId(bytesInfo.getFileId());
        return knowledge;
    }

    @Override
    public List<ExtractRecord> extract(Knowledge knowledge, List<ExtractItemDto> itemDtoList) {
        log.info("NLP>>>\u8fdb\u5165NlpMethodExtractor\u7684extract\uff0c\u5f00\u59cb\u6267\u884c");
        ArrayList nlpTypeInfos = new ArrayList();
        for (ExtractItemDto itemDto : itemDtoList) {
            List relevancyList = itemDto.getTypeInfoList();
            Iterator iterator = relevancyList.iterator();
            while (iterator.hasNext()) {
                ExtractTypeInfo info = (ExtractTypeInfo)iterator.next();
                info.setExtractItemId(itemDto.getId());
            }
            nlpTypeInfos.addAll(relevancyList);
        }
        CopyOnWriteArrayList<ExtractRecord> result = new CopyOnWriteArrayList<ExtractRecord>();
        CountDownLatch latch = new CountDownLatch(nlpTypeInfos.size());
        if (CollUtil.isNotEmpty(nlpTypeInfos)) {
            for (ExtractTypeInfo nlpTypeInfo : nlpTypeInfos) {
                ThreadPoolUtil.getInstance().execute(() -> {
                    try {
                        Knowledge askKnowledge = new Knowledge();
                        BeanUtils.copyProperties((Object)knowledge, (Object)askKnowledge);
                        log.info("NLP>>>\u3010{}\u3011\u5f00\u59cb\u6267\u884c", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                        NlpOldConfig config = (NlpOldConfig)nlpTypeInfo.extractConfig(NlpOldConfig.class);
                        IChannelExtractor channelExtractor = (IChannelExtractor)this.CHANNEL_EXTRACTORS.get(nlpTypeInfo.getExtractType());
                        ExtractResult extractResult = channelExtractor.execute(knowledge, config);
                        log.info("NLP>>>\u3010{}\u3011\u6267\u884c\u5b8c\u6210", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                        ExtractRecord record = new ExtractRecord();
                        record.setItemName(nlpTypeInfo.getName());
                        record.setObjectId(nlpTypeInfo.getCode());
                        record.setExtractItemId(nlpTypeInfo.getExtractItemId());
                        record.setResult(JSON.toJSONString((Object)extractResult.getResult()));
                        record.setResultObject(extractResult.getResult());
                        record.setReturnType(extractResult.getReturnType());
                        record.setExtractType(nlpTypeInfo.getExtractType());
                        result.add(record);
                    }
                    catch (Exception ignored) {
                        log.error("NLP>>>\u3010{}\u3011\u6267\u884c\u5f02\u5e38", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("\u4e3b\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.server.deleteKnowledgeBase(knowledge);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u77e5\u8bc6\u5e93\u5931\u8d25", (Throwable)e);
        }
        return result;
    }
}

