/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method.llm;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.enums.doc.DocFormat;
import com.jxdinfo.idp.common.threepartapi.rag.IKnowledgeBaseServer;
import com.jxdinfo.idp.common.util.file.DocumentFormatDetector;
import com.jxdinfo.idp.extract.core.api.IChannelExtractor;
import com.jxdinfo.idp.extract.core.extractor.method.AbstractMethodExtractor;
import com.jxdinfo.idp.extract.core.util.Pdf2ImgUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpChatConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MLLMMethodExtractor
extends AbstractMethodExtractor<FileBytesInfo, List<ConfigDocMarkTemplate>> {
    private static final Logger log = LoggerFactory.getLogger(MLLMMethodExtractor.class);
    @Autowired
    private IKnowledgeBaseServer server;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto("mllm", "\u591a\u6a21\u6001\u5927\u6a21\u578b", 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return "nlp";
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        if (info instanceof FileBytesInfo) {
            DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])((FileBytesInfo)info).getFileBytes(), (String)((FileBytesInfo)info).getFileName());
            return format == DocFormat.PDF || format == DocFormat.JPEG || format == DocFormat.PNG || format == DocFormat.JPG;
        }
        return false;
    }

    @Override
    public List<ConfigDocMarkTemplate> before(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        List<Object> markTemplates = new ArrayList();
        int maxPageNum = 0;
        for (ExtractItemDto itemDto : itemDtoList) {
            List relevancyList = itemDto.getTypeInfoList();
            for (ExtractTypeInfo info : relevancyList) {
                NlpChatConfig config = (NlpChatConfig)info.extractConfig(NlpChatConfig.class);
                if (config.getPageNum() <= 0) continue;
                maxPageNum = Math.max(maxPageNum, config.getPageNum());
            }
        }
        if (maxPageNum == 0) {
            maxPageNum = 3;
        }
        ArrayList<Integer> pageNums = new ArrayList<Integer>();
        for (int i = 0; i < maxPageNum; ++i) {
            pageNums.add(i);
        }
        DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])bytesInfo.getFileBytes(), (String)bytesInfo.getFileName());
        if (format == DocFormat.PDF) {
            markTemplates = Pdf2ImgUtil.pdf2ImageBase64(bytesInfo, 96, pageNums, true);
        } else if (format == DocFormat.PNG || format == DocFormat.JPG || format == DocFormat.JPEG) {
            Base64.Encoder encoder = Base64.getEncoder();
            String base64 = "data:image/png;base64," + encoder.encodeToString(bytesInfo.getFileBytes());
            ConfigDocMarkTemplate template = new ConfigDocMarkTemplate();
            template.setCurrentPage(1);
            template.setImgBase64(base64);
            markTemplates.add(template);
        }
        if (markTemplates == null || markTemplates.isEmpty()) {
            log.error("PDF\u6587\u4ef6\u8f6c\u6362\u56fe\u72470\u6761" + bytesInfo.getFileName() + "," + bytesInfo.getFileId());
        }
        return markTemplates;
    }

    @Override
    public List<ExtractRecord> extract(List<ConfigDocMarkTemplate> markTemplates, List<ExtractItemDto> itemDtoList) {
        log.info("NLP>>>\u8fdb\u5165MLLMMethodExtractor\u7684extract\uff0c\u5f00\u59cb\u6267\u884c");
        if (markTemplates == null || markTemplates.isEmpty()) {
            return new ArrayList<ExtractRecord>();
        }
        ArrayList nlpTypeInfos = new ArrayList();
        for (ExtractItemDto itemDto : itemDtoList) {
            List relevancyList = itemDto.getTypeInfoList();
            Iterator iterator = relevancyList.iterator();
            while (iterator.hasNext()) {
                ExtractTypeInfo info = (ExtractTypeInfo)iterator.next();
                info.setExtractItemId(itemDto.getId());
            }
            nlpTypeInfos.addAll(relevancyList);
        }
        CopyOnWriteArrayList<ExtractRecord> result = new CopyOnWriteArrayList<ExtractRecord>();
        CountDownLatch latch = new CountDownLatch(nlpTypeInfos.size());
        if (CollUtil.isNotEmpty(nlpTypeInfos)) {
            for (ExtractTypeInfo nlpTypeInfo : nlpTypeInfos) {
                ThreadPoolUtil.getInstance().execute(() -> {
                    try {
                        log.info("MNLP>>>\u3010{}\u3011\u5f00\u59cb\u6267\u884c", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                        NlpChatConfig config = (NlpChatConfig)nlpTypeInfo.extractConfig(NlpChatConfig.class);
                        IChannelExtractor channelExtractor = (IChannelExtractor)this.CHANNEL_EXTRACTORS.get(nlpTypeInfo.getExtractType());
                        ExtractResult extractResult = channelExtractor.execute(markTemplates, config);
                        log.info("MNLP>>>\u3010{}\u3011\u6267\u884c\u5b8c\u6210", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                        ExtractRecord record = new ExtractRecord();
                        record.setItemName(nlpTypeInfo.getName());
                        record.setObjectId(nlpTypeInfo.getCode());
                        record.setExtractItemId(nlpTypeInfo.getExtractItemId());
                        record.setResult(JSON.toJSONString((Object)extractResult.getResult()));
                        record.setResultObject(extractResult.getResult());
                        record.setReturnType(extractResult.getReturnType());
                        record.setExtractType(nlpTypeInfo.getExtractType());
                        result.add(record);
                    }
                    catch (Exception ignored) {
                        log.error("MNLP>>>\u3010{}\u3011\u6267\u884c\u5f02\u5e38", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()), (Object)ignored);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("\u4e3b\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return result;
    }
}

