/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.enums.doc.DocFormat;
import com.jxdinfo.idp.common.util.file.DocumentFormatDetector;
import com.jxdinfo.idp.extract.core.entity.dto.JsonInfo;
import com.jxdinfo.idp.extract.core.extractor.method.AbstractMethodExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonMethodExtractor
extends AbstractMethodExtractor<FileBytesInfo, JsonInfo> {
    private static final Logger log = LoggerFactory.getLogger(JsonMethodExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel2Enum.JSON.getCode(), GroupLevel2Enum.JSON.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel2Enum.JSON.getLevel1Enum().getCode();
    }

    @Override
    public JsonInfo before(FileBytesInfo jsonObject, List<ExtractItemDto> extractItemPoList) {
        try {
            String jsonStr = new String(jsonObject.getFileBytes());
            jsonStr = jsonStr.trim();
            if (jsonStr.startsWith("{") && jsonStr.endsWith("}")) {
                return new JsonInfo(jsonObject.getFileId(), (JSON)JSON.parseObject((String)jsonStr));
            }
            if (jsonStr.startsWith("[") && jsonStr.endsWith("]")) {
                return new JsonInfo(jsonObject.getFileId(), (JSON)JSON.parseArray((String)jsonStr));
            }
        }
        catch (Exception e) {
            log.error("\u3010{}\u3011\u63d0\u53d6\u5668\u4e0d\u652f\u6301\u3010{}\u3011\u8fdb\u884c\u63d0\u53d6\uff0c\u8bf7\u786e\u8ba4\u63d0\u53d6\u9879\u914d\u7f6e\u4e0e\u6587\u6863\u4e0a\u4f20\u65e0\u8bef\uff01", (Object)this.implCodeDto().getImplName(), (Object)jsonObject.getFileName());
        }
        return new JsonInfo(jsonObject.getFileId(), (JSON)new JSONObject());
    }

    @Override
    public boolean supportInputParam(Object info) {
        if (info == null) {
            return false;
        }
        if (info instanceof FileBytesInfo) {
            DocFormat format = DocumentFormatDetector.detectDocumentFormat((byte[])((FileBytesInfo)info).getFileBytes(), (String)((FileBytesInfo)info).getFileName());
            return format == DocFormat.JSON;
        }
        return false;
    }
}

