/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.method;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.extract.core.api.IChannelExtractor;
import com.jxdinfo.idp.extract.core.api.IMethodExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSealInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSignInfo;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMethodExtractor<E, S>
implements IMethodExtractor<E, S>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractMethodExtractor.class);
    @Autowired(required=false)
    private List<IChannelExtractor> channelExtractors;
    protected final Map<String, IChannelExtractor> CHANNEL_EXTRACTORS = new LinkedHashMap<String, IChannelExtractor>();

    @Override
    public abstract String belongExtractorImplCode();

    public void afterPropertiesSet() {
        if (CollUtil.isNotEmpty(this.channelExtractors)) {
            List extractors = this.channelExtractors.stream().sorted(Comparator.comparingInt(o -> o.implCodeDto().getSortNum())).collect(Collectors.toList());
            for (IChannelExtractor extractor : extractors) {
                if (!Objects.equals(extractor.belongExtractorImplCode(), this.implCodeDto().getImplCode())) continue;
                this.CHANNEL_EXTRACTORS.put(extractor.implCodeDto().getImplCode(), extractor);
                log.info("\u6ce8\u518c\u63d0\u53d6\u901a\u9053\u6267\u884c\u5668\uff1a{}->{}", (Object)extractor.implCodeDto().getImplName(), (Object)this.implCodeDto().getImplName());
            }
        }
    }

    @Override
    public List<GroupLevel> getExtractorList() {
        ArrayList<GroupLevel> list = new ArrayList<GroupLevel>();
        this.CHANNEL_EXTRACTORS.forEach((methodExtractorImplCode, extractor) -> {
            GroupLevel groupLevel = new GroupLevel(extractor.implCodeDto().getImplCode(), extractor.implCodeDto().getImplName());
            groupLevel.setSupportDataTypes(extractor.supportDataTypes());
            list.add(groupLevel);
        });
        return list;
    }

    @Override
    public boolean support(String extractType) {
        return this.CHANNEL_EXTRACTORS.containsKey(extractType);
    }

    @Override
    public List<?> execute(E e, List<ExtractItemDto> itemDtoList) {
        Object before;
        try {
            before = this.before(e, itemDtoList);
        }
        catch (Exception exception) {
            log.error("{}\u524d\u7f6e\u5904\u7406\u5f02\u5e38\uff01", (Object)this.implCodeDto().getImplCode(), (Object)exception);
            return new ArrayList();
        }
        return this.extract(before, itemDtoList);
    }

    @Override
    public List<ExtractRecord> extract(S s, List<ExtractItemDto> itemDtoList) {
        log.info("\u63d0\u53d6>>\u3010AbstractItemExtractor.extract\u3011\u5f00\u59cb\u6267\u884c");
        ArrayList<ExtractRecord> recordList = new ArrayList<ExtractRecord>();
        for (ExtractItemDto dto : itemDtoList) {
            try {
                ArrayList<ExtractResult> resultList = new ArrayList<ExtractResult>();
                for (ExtractTypeInfo relevancy : dto.getTypeInfoList()) {
                    Object config;
                    IChannelExtractor channelExtractor = this.CHANNEL_EXTRACTORS.get(relevancy.getExtractType());
                    if (channelExtractor == null) {
                        log.error("{}\u63d0\u53d6\u672a\u627e\u5230\u6267\u884c\u5668\uff1a{}", (Object)dto.getName(), (Object)relevancy.getExtractType());
                        continue;
                    }
                    if (channelExtractor.getConfigClass() == null) {
                        log.error("{}\u63d0\u53d6\u901a\u8fc7\u9700\u8981\u7684\u914d\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff0c\u68c0\u67e5getConfigClass\u8fd4\u56de\u503c\u662f\u5426\u662fExtractConfig\u53ca\u5176\u5b50\u7c7b", (Object)dto.getName());
                    }
                    if (!((config = JSON.parseObject((String)relevancy.getConfig(), channelExtractor.getConfigClass())) instanceof ExtractConfig)) {
                        log.error("{}\u63d0\u53d6\u9879\u914d\u7f6e\u8f6c\u6362\u5f02\u5e38\uff01\u914d\u7f6e\u4fe1\u606f\uff1a{}\uff0c\u8f6c\u6362\u76ee\u6807\uff1a{}", new Object[]{dto.getName(), relevancy.getConfig(), channelExtractor.getConfigClass()});
                        continue;
                    }
                    ExtractConfig extractConfig = (ExtractConfig)config;
                    extractConfig.setDataType(dto.getReturnType());
                    extractConfig.setMatchStrategy(dto.getIntegrationType() == null ? 0 : dto.getIntegrationType());
                    ExtractResult extractResult = null;
                    try {
                        extractResult = channelExtractor.execute(s, extractConfig);
                    }
                    catch (Exception e) {
                        log.error("\u63d0\u53d6\u9879\u3010" + dto.getName() + "\u3011\u63d0\u53d6\u5f02\u5e38\uff01", (Throwable)e);
                    }
                    resultList.add(extractResult);
                }
                ExtractRecord record = this.extractRecord(dto);
                this.integration(record, resultList, dto.getIntegrationType(), dto.getExceptionValue());
                recordList.add(record);
            }
            catch (Exception e) {
                log.error("AbstractItemExtractor.execute\u6267\u884c\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        return recordList;
    }

    protected void integration(ExtractRecord record, List<ExtractResult> resultList, Integer integrationType, String exceptionValue) {
        AtomicReference lastResult = new AtomicReference();
        resultList.removeIf(o -> {
            if (o == null || o.getResult() == null) {
                return true;
            }
            lastResult.set(o);
            if (o.getResult() instanceof List) {
                return CollUtil.isEmpty((Collection)((List)o.getResult()));
            }
            if (o.getResult() instanceof SingleSealInfo) {
                return !((SingleSealInfo)o.getResult()).isFlag();
            }
            if (o.getResult() instanceof SingleSignInfo) {
                return !((SingleSignInfo)o.getResult()).isFlag();
            }
            return false;
        });
        if (CollUtil.isNotEmpty(resultList)) {
            ExtractResult result = resultList.get(0);
            if (1 == integrationType) {
                result = resultList.get(resultList.size() - 1);
            }
            record.setLocation(result.getLocation());
            record.setResult(JSON.toJSONString((Object)result.getResult()));
            record.setResultObject(result.getResult());
            record.setExtractType(result.getExtractType());
            record.setReturnType(result.getReturnType());
        } else if (Objects.equals(this.implCodeDto().getImplCode(), GroupLevel2Enum.OCR.getCode()) && lastResult.get() != null) {
            record.setResult(JSON.toJSONString((Object)((ExtractResult)lastResult.get()).getResult()));
            record.setResultObject(((ExtractResult)lastResult.get()).getResult());
            record.setReturnType(((ExtractResult)lastResult.get()).getReturnType());
            record.setExtractType(((ExtractResult)lastResult.get()).getExtractType());
        }
    }

    public ExtractRecord extractRecord(ExtractItemDto itemDto) {
        ExtractRecord record = new ExtractRecord();
        record.setExtractItemId(itemDto.getId());
        record.setItemName(itemDto.getName());
        return record;
    }
}

