/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.word;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="wordTableChannelExtractor")
public class WordTableExtractor
extends AbstractChannelExtractor<WordInfo, WordTableConfig> {
    private static final Logger log = LoggerFactory.getLogger(WordTableExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_TABLE.getCode(), GroupLevel3Enum.WORD_TABLE.getName(), 3);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.WORD_TABLE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return WordTableConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(WordInfo wordInfo, WordTableConfig wordTableConfig) {
    }

    @Override
    public List<ExtractResult> extract(WordInfo structureInfo, WordTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010WordTableExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        List tableInfos = structureInfo.getTableInfos();
        List cellNames = config.getCellNames();
        if (CollUtil.isNotEmpty((Collection)cellNames)) {
            for (WordTableInfo tableInfo : tableInfos) {
                List rows = tableInfo.getRows();
                int index = 0;
                String cellName = (String)cellNames.get(index);
                block1: for (WordRowInfo row : rows) {
                    List cells = row.getCells();
                    for (WordCellInfo cell : cells) {
                        if (!MatchTextUtil.isFuzzyMatched((String)cellName, (String)cell.getText())) continue;
                        if (++index >= cellNames.size()) break block1;
                        cellName = (String)cellNames.get(index);
                    }
                }
                if (index != cellNames.size()) continue;
                TempLocation location = new TempLocation();
                location.setFileId(structureInfo.getFileId());
                result.add(new ExtractResult((Object)tableInfo, (Location)location, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
            }
        }
        return result;
    }

    @Override
    public ExtractResult after(List<ExtractResult> list, WordTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010WordTableExtractor.after\u3011");
        ExtractResult result = this.dealData(list, config);
        if (result != null) {
            result.setResult(this.afterHandler(result.getResult(), config));
        }
        return result;
    }

    private ExtractResult dealData(List<ExtractResult> list, WordTableConfig config) {
        int matchStrategy = config.getMatchStrategy();
        if (CollUtil.isNotEmpty(list)) {
            List rowsList;
            ExtractResult result = matchStrategy == 0 ? list.get(0) : list.get(list.size() - 1);
            ArrayList<Table> tableList = new ArrayList<Table>();
            Object object = result.getResult();
            if (object instanceof WordTableInfo && (rowsList = ((WordTableInfo)object).getRows()) != null && !rowsList.isEmpty()) {
                Table table = new Table();
                ArrayList<Cell> targetCells = new ArrayList<Cell>();
                table.setCells(targetCells);
                int rowIndex = 0;
                String rowText = "";
                for (Object o : rowsList) {
                    int colIndex = 0;
                    if (o instanceof WordRowInfo) {
                        for (WordCellInfo cellInfo : ((WordRowInfo)o).getCells()) {
                            if (rowIndex == 0) {
                                rowText = rowText + cellInfo.getText();
                            }
                            Cell targetCell = new Cell();
                            targetCell.setCol(Integer.valueOf(colIndex));
                            targetCell.setRow(Integer.valueOf(rowIndex));
                            targetCell.setColSpan(cellInfo.getColSpan());
                            targetCell.setRowSpan(cellInfo.getRowSpan());
                            targetCell.setText(cellInfo.getText());
                            targetCells.add(targetCell);
                            ++colIndex;
                        }
                    }
                    ++rowIndex;
                }
                tableList.add(table);
                TempLocation location = new TempLocation();
                location.setContext(rowText);
                location.setText(rowText);
                location.setFileId(result.getLocation() != null ? result.getLocation().getFileId() : null);
                result.setResult(tableList);
                result.setLocation((Location)location);
                return result;
            }
            return result;
        }
        return null;
    }
}

