/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.word;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphPageInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTablePageInfo;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordPageConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="wordPageChannelExtractor")
public class WordPageExtractor
extends AbstractChannelExtractor<WordInfo, WordPageConfig> {
    private static final Logger log = LoggerFactory.getLogger(WordPageExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_PAGE.getCode(), GroupLevel3Enum.WORD_PAGE.getName(), 4);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.WORD_PAGE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return WordPageConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.PAGEMAP.getKey());
        return list;
    }

    @Override
    public void before(WordInfo wordInfo, WordPageConfig wordPageConfig) {
    }

    @Override
    public List<ExtractResult> extract(WordInfo wordInfo, WordPageConfig wordPageConfig) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010WordPageExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        HashMap pageMap = new HashMap();
        int pageNum = 1;
        ArrayList<WordElementInfo> pageInfos = new ArrayList<WordElementInfo>();
        for (WordElementInfo elementInfo : wordInfo.getElementInfos()) {
            WordTablePageInfo wordTablePageInfo;
            WordTableInfo tableInfo;
            List tablePageInfos;
            if (elementInfo instanceof WordParagraphInfo) {
                WordParagraphPageInfo wordParagraphPageInfo;
                WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
                List paraPageInfos = paragraphInfo.getParaPageInfos();
                if (paraPageInfos == null || paraPageInfos.isEmpty() || (wordParagraphPageInfo = (WordParagraphPageInfo)paragraphInfo.getParaPageInfos().get(0)) == null) continue;
                if (wordParagraphPageInfo.getPageNum() == pageNum) {
                    pageInfos.add(elementInfo);
                    continue;
                }
                pageMap.put(pageNum, pageInfos);
                pageNum = wordParagraphPageInfo.getPageNum();
                pageInfos = new ArrayList();
                pageInfos.add(elementInfo);
                continue;
            }
            if (!(elementInfo instanceof WordTableInfo) || (tablePageInfos = (tableInfo = (WordTableInfo)elementInfo).getTablePageInfos()) == null || tablePageInfos.isEmpty() || (wordTablePageInfo = (WordTablePageInfo)tableInfo.getTablePageInfos().get(0)) == null) continue;
            if (wordTablePageInfo.getPageNum() == pageNum) {
                pageInfos.add(elementInfo);
                continue;
            }
            pageMap.put(pageNum, pageInfos);
            pageNum = wordTablePageInfo.getPageNum();
            pageInfos = new ArrayList();
            pageInfos.add(elementInfo);
        }
        if (!pageInfos.isEmpty()) {
            pageMap.put(pageNum, pageInfos);
        }
        String orderNum = wordPageConfig.getPageNum();
        if (pageMap.isEmpty()) {
            return result;
        }
        if (orderNum == null || orderNum.isEmpty()) {
            result.add(new ExtractResult(pageMap, ReturnTypeEnum.PAGEMAP.getKey(), this.implCodeDto().getImplCode()));
        } else {
            String[] orderNumList;
            HashMap resultMap = new HashMap();
            for (String num : orderNumList = orderNum.split(",")) {
                if (!pageMap.containsKey(Integer.parseInt(num))) continue;
                resultMap.put(Integer.parseInt(num), pageMap.get(Integer.parseInt(num)));
            }
            result.add(new ExtractResult(resultMap, ReturnTypeEnum.PAGEMAP.getKey(), this.implCodeDto().getImplCode()));
        }
        return result;
    }
}

