/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.word;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordChapterConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="wordChapterChannelExtractor")
public class WordChapterExtractor
extends AbstractChannelExtractor<WordInfo, WordChapterConfig> {
    private static final Logger log = LoggerFactory.getLogger(WordChapterExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_CHAPTER.getCode(), GroupLevel3Enum.WORD_CHAPTER.getName(), 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.WORD_CHAPTER.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return WordChapterConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(WordInfo wordInfo, WordChapterConfig wordChapterConfig) {
    }

    @Override
    public List<ExtractResult> extract(WordInfo wordInfo, WordChapterConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010WordChapterExtractor.extract\u3011");
        List chapterInfos = wordInfo.getChapterInfos();
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        for (WordChapterInfo chapterInfo : chapterInfos) {
            if (!this.match(chapterInfo.getTitleName(), config)) continue;
            TempLocation location = new TempLocation(chapterInfo.getTitleName(), chapterInfo.getTitleName());
            ExtractResult extractResult = new ExtractResult((Object)chapterInfo.getText(), (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.WORD_CHAPTER.getCode());
            extractResult.getLocation().setFileId(wordInfo.getFileId());
            result.add(extractResult);
        }
        return result;
    }

    private boolean match(String title, WordChapterConfig config) {
        String matchText = config.getMatchText();
        if (config.getHandleMethod() == 0) {
            title = title.replaceAll(" |\n|", "");
            matchText = matchText.replaceAll(" |\n|", "");
            return title.contains(matchText);
        }
        if (config.getHandleMethod() == 1) {
            Pattern pattern = Pattern.compile(matchText);
            Matcher matcher = pattern.matcher(title);
            return matcher.find();
        }
        return false;
    }
}

