/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.word;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordBasicTypeConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="wordBasicTypeChannelExtract")
public class WordBasicTypeExtractor
extends AbstractChannelExtractor<WordInfo, WordBasicTypeConfig> {
    private static final Logger log = LoggerFactory.getLogger(WordBasicTypeExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_BASIC_TYPE.getCode(), GroupLevel3Enum.WORD_BASIC_TYPE.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.WORD_BASIC_TYPE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return WordBasicTypeConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(WordInfo wordInfo, WordBasicTypeConfig config) {
    }

    @Override
    public List<ExtractResult> extract(WordInfo wordInfo, WordBasicTypeConfig config) {
        WordParagraphInfo paragraphInfo;
        WordElementInfo elementInfo;
        int i;
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010WordBasicTypeExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (wordInfo == null || wordInfo.getElementInfos() == null || wordInfo.getElementInfos().isEmpty()) {
            return result;
        }
        int startIndex = 0;
        int endIndex = wordInfo.getElementInfos().size();
        List elementInfos = wordInfo.getElementInfos();
        if (StringUtils.isNotEmpty((String)config.getStartRegex())) {
            for (i = 0; i < elementInfos.size(); ++i) {
                elementInfo = (WordElementInfo)elementInfos.get(i);
                if (!"para".equals(elementInfo.getType()) || !(elementInfo instanceof WordParagraphInfo)) continue;
                paragraphInfo = (WordParagraphInfo)elementInfo;
                if (!MatchTextUtil.isMatch((String)config.getStartRegex(), (String)paragraphInfo.getText()).booleanValue()) continue;
                startIndex = i;
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)config.getEndRegex())) {
            for (i = startIndex; i < elementInfos.size(); ++i) {
                elementInfo = (WordElementInfo)elementInfos.get(i);
                if (!"para".equals(elementInfo.getType()) || !(elementInfo instanceof WordParagraphInfo)) continue;
                paragraphInfo = (WordParagraphInfo)elementInfo;
                if (!MatchTextUtil.isMatch((String)config.getEndRegex(), (String)paragraphInfo.getText()).booleanValue()) continue;
                endIndex = i + 1;
                break;
            }
        }
        ArrayList<WordTableInfo> targetTables = new ArrayList<WordTableInfo>();
        StringBuilder paraString = new StringBuilder();
        int startOffsetIndex = startIndex;
        if (config.getStartOffset() != null) {
            startOffsetIndex = startIndex + config.getStartOffset();
        }
        int endOffsetIndex = endIndex;
        if (config.getEndOffset() != null) {
            endOffsetIndex = endIndex + config.getEndOffset();
        }
        if (startOffsetIndex >= endOffsetIndex) {
            log.info("\u63d0\u53d6>>\u8d77\u59cb\u7ec8\u6b62\u7d22\u5f15\u4e0d\u80fd\u76f8\u540c");
            return result;
        }
        for (int i2 = Math.max(0, startOffsetIndex); i2 < Math.min(elementInfos.size(), endOffsetIndex); ++i2) {
            WordParagraphInfo paraInfo;
            WordElementInfo elementInfo2 = (WordElementInfo)elementInfos.get(i2);
            if ("para".equals(config.getSource()) && elementInfo2 instanceof WordParagraphInfo && StringUtils.isNotBlank((CharSequence)(paraInfo = (WordParagraphInfo)elementInfo2).getText())) {
                if (StringUtils.isEmpty((String)config.getRegex())) {
                    paraString.append(paraInfo.getText());
                } else {
                    List<Object> match = this.match(config.getRegex(), paraInfo.getText());
                    if (CollUtil.isEmpty(match)) continue;
                    match.forEach(matchObj -> {
                        String context = paraInfo.getText().length() > 100 ? paraInfo.getText().substring(0, 100) : paraInfo.getText();
                        TempLocation location = new TempLocation(context, matchObj.toString());
                        location.setFileId(wordInfo.getFileId());
                        ExtractResult matchResult = new ExtractResult(matchObj, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.WORD_BASIC_TYPE.getCode());
                        result.add(matchResult);
                    });
                }
            }
            if (!(elementInfo2 instanceof WordTableInfo)) continue;
            targetTables.add((WordTableInfo)elementInfo2);
        }
        if ("para".equals(config.getSource())) {
            if (StringUtils.isBlank((CharSequence)config.getRegex()) && paraString.length() != 0) {
                TempLocation location = new TempLocation();
                location.setFileId(wordInfo.getFileId());
                location.setText(paraString.length() > 100 ? paraString.substring(0, 100) : paraString.toString());
                location.setContext(paraString.length() > 100 ? paraString.substring(0, 100) : paraString.toString());
                ExtractResult paraStringResult = new ExtractResult((Object)paraString.toString(), (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.WORD_BASIC_TYPE.getCode());
                result.add(paraStringResult);
            }
        } else if ("table".equals(config.getSource())) {
            List<ExtractResult> objects = this.getFromAllTable(targetTables, config.getXOffset(), config.getYOffset(), config.getBasicText(), config.getRegex(), wordInfo.getFileId());
            result.addAll(objects);
        }
        return result;
    }

    private List<ExtractResult> getFromAllTable(List<WordTableInfo> tableInfos, int xOffset, int yOffset, String basicText, String regex, Long fileId) {
        List xList;
        LinkedHashMap<Integer, Map> tableCoordinateMap = new LinkedHashMap<Integer, Map>();
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (CollUtil.isEmpty(tableInfos)) {
            return new ArrayList<ExtractResult>();
        }
        for (int i = 0; i < tableInfos.size(); ++i) {
            WordTableInfo tableInfo = tableInfos.get(i);
            List rows = tableInfo.getRows();
            for (WordRowInfo row : rows) {
                List cells = row.getCells();
                for (WordCellInfo cell : cells) {
                    if (!MatchTextUtil.isFuzzyMatched((String)basicText, (String)cell.getText())) continue;
                    Map coordinateMap = tableCoordinateMap.computeIfAbsent(i, k -> new LinkedHashMap());
                    xList = coordinateMap.computeIfAbsent(row.getIndex(), k -> new ArrayList());
                    xList.add(cell.getIndex());
                }
            }
        }
        for (Map.Entry entry : tableCoordinateMap.entrySet()) {
            Integer tableIndex = (Integer)entry.getKey();
            Map coordinateMap = (Map)entry.getValue();
            for (Map.Entry coordinateEntry : coordinateMap.entrySet()) {
                int y = (Integer)coordinateEntry.getKey();
                int targetY = y + yOffset;
                if (targetY < 0 || targetY >= tableInfos.get(tableIndex).getRows().size()) continue;
                xList = (List)coordinateEntry.getValue();
                for (Integer x : xList) {
                    int targetX = x + xOffset;
                    if (targetX < 0 || targetX >= ((WordRowInfo)tableInfos.get(tableIndex).getRows().get(y)).getCells().size()) continue;
                    try {
                        WordCellInfo cellInfo = (WordCellInfo)((WordRowInfo)tableInfos.get(tableIndex).getRows().get(targetY)).getCells().get(targetX);
                        if (StringUtils.isEmpty((String)regex)) {
                            ExtractResult matchResult = new ExtractResult((Object)cellInfo.getText(), (Location)new TempLocation(cellInfo.getText(), cellInfo.getText()), ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.WORD_BASIC_TYPE.getCode());
                            matchResult.getLocation().setFileId(fileId);
                            result.add(matchResult);
                            continue;
                        }
                        List<Object> match = this.match(regex, cellInfo.getText());
                        if (CollUtil.isEmpty(match)) continue;
                        match.forEach(matchObj -> {
                            String context = cellInfo.getText().length() > 100 ? cellInfo.getText().substring(0, 100) : cellInfo.getText();
                            TempLocation location = new TempLocation(context, matchObj.toString());
                            ExtractResult matchResult = new ExtractResult(matchObj, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.WORD_BASIC_TYPE.getCode());
                            matchResult.getLocation().setFileId(fileId);
                            result.add(matchResult);
                        });
                    }
                    catch (Exception e) {
                        log.error("\u4eceword\u8868\u683c\u91cd\u63d0\u53d6\u57fa\u672c\u7c7b\u578b\u6570\u636egetFromAllTable,\u672a\u5bfb\u627e\u5230\u76ee\u6807\u5355\u5143\u683c:" + e.getMessage());
                    }
                }
            }
        }
        return result;
    }
}

