/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.sql;

import cn.hutool.core.util.ObjectUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.mapper.ExtractorMapper;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.info.InfoExtractConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sqlInfoChannelExtract")
public class SQLSimpleExtractor
extends AbstractChannelExtractor<Object, InfoExtractConfig> {
    private static final Logger log = LoggerFactory.getLogger(SQLSimpleExtractor.class);
    @Resource
    private ExtractorMapper mapper;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.INFO_EXTRACT.getCode(), GroupLevel3Enum.INFO_EXTRACT.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.INFO_EXTRACT.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return InfoExtractConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(Object obj, InfoExtractConfig config) {
    }

    @Override
    public List<ExtractResult> extract(Object structureInfo, InfoExtractConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010DocInfoSQLExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (ObjectUtil.isNotNull((Object)config.getExtractSQL())) {
            String sql = config.getExtractSQL().replaceAll("(?i)update ", "").replaceAll("(?i)insert ", "").replaceAll("(?i)delete ", "");
            Collection list = this.mapper.docInfoSQLExtractor(sql);
            ArrayList<Table> resultList = new ArrayList<Table>();
            resultList.add(this.transTable(list));
            result.add(new ExtractResult(resultList, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
        }
        return result;
    }

    private Table transTable(Collection<?> list) {
        Table table = new Table();
        table.setCells(new ArrayList());
        Map header = (Map)list.iterator().next();
        List headerList = header.keySet().stream().map(this::toString).collect(Collectors.toList());
        AtomicInteger colIndex = new AtomicInteger(0);
        for (String text : headerList) {
            Cell cell = new Cell();
            cell.setCol(Integer.valueOf(colIndex.get()));
            cell.setRow(Integer.valueOf(0));
            cell.setText(text);
            cell.setColSpan(Integer.valueOf(1));
            cell.setRowSpan(Integer.valueOf(1));
            table.getCells().add(cell);
            colIndex.getAndIncrement();
        }
        AtomicInteger rowIndex = new AtomicInteger(1);
        list.forEach(item -> {
            Map col = (Map)item;
            colIndex.set(0);
            headerList.forEach(key -> {
                Cell cell = new Cell();
                cell.setCol(Integer.valueOf(colIndex.get()));
                cell.setRow(Integer.valueOf(rowIndex.get()));
                cell.setRowSpan(Integer.valueOf(1));
                cell.setColSpan(Integer.valueOf(1));
                cell.setText(this.toString(col.get(key)));
                table.getCells().add(cell);
            });
            rowIndex.getAndIncrement();
        });
        return table;
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }
}

