/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.pdf;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.ResolvablePDFTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="resolvablePDFTableChannelExtractor")
public class ResolvablePDFTableExtractor
extends AbstractChannelExtractor<FileBytesInfo, ResolvablePDFTableConfig> {
    private static final Logger log = LoggerFactory.getLogger(ResolvablePDFTableExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.RESOLVABLE_PDF_TABLE.getCode(), GroupLevel3Enum.RESOLVABLE_PDF_TABLE.getName(), 3);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.RESOLVABLE_PDF_TABLE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return ResolvablePDFTableConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(FileBytesInfo contentPojo, ResolvablePDFTableConfig config) {
    }

    @Override
    public List<ExtractResult> extract(FileBytesInfo fileBytesInfo, ResolvablePDFTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010ResolvablePDFTableExtractor.extract\u3011" + fileBytesInfo.getFileName());
        ContentPojo pojo = null;
        try {
            PDDocument document = PDDocument.load((byte[])fileBytesInfo.getFileBytes());
            pojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)document, (boolean)true, (!config.isCrossPageTable() ? 1 : 0) != 0);
        }
        catch (IOException e) {
            return new ArrayList<ExtractResult>();
        }
        List elements = pojo.getOutList();
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (CollUtil.isEmpty((Collection)elements)) {
            return new ArrayList<ExtractResult>();
        }
        boolean lastElIsTable = false;
        block2: for (ContentPojo.contentElement element : elements) {
            List cells;
            if (config.isCrossPageTable() && !result.isEmpty() && lastElIsTable && "table".equals(element.getElementType()) && !CollUtil.isEmpty((Collection)element.getCells())) {
                ExtractResult lastResult = (ExtractResult)result.get(result.size() - 1);
                List tableList = (List)lastResult.getResult();
                Table lastTable = (Table)tableList.get(tableList.size() - 1);
                Integer tablePageNum = lastTable.getPagenum();
                if (tablePageNum + 1 == element.getPageNumber()) {
                    Table table = this.tableConvert(element.getCells());
                    table.setPagenum(element.getPageNumber());
                    tableList.add(table);
                    continue;
                }
                lastElIsTable = false;
            } else {
                lastElIsTable = false;
            }
            if (!"table".equals(element.getElementType()) || CollUtil.isEmpty((Collection)(cells = element.getCells()))) continue;
            block3: for (String cellKey : config.getCellKey()) {
                List<String> regexes = Arrays.asList(cellKey.split(";"));
                for (int i = 0; i < regexes.size(); ++i) {
                    int cellIndex = 0;
                    ContentPojo.contentElement.InnerCell cell = (ContentPojo.contentElement.InnerCell)cells.get(cellIndex);
                    String regex = regexes.get(i);
                    while (!MatchTextUtil.isMatch((String)regex, (String)this.getCellText(cell.getText())).booleanValue()) {
                        if (++cellIndex >= cells.size()) continue block3;
                        cell = (ContentPojo.contentElement.InnerCell)cells.get(cellIndex);
                    }
                    if (i != regexes.size() - 1) continue;
                    ArrayList<Table> tableList = new ArrayList<Table>();
                    Table table = this.tableConvert(cells);
                    table.setPagenum(element.getPageNumber());
                    tableList.add(table);
                    TempLocation tempLocation = new TempLocation();
                    tempLocation.setFileId(fileBytesInfo.getFileId());
                    result.add(new ExtractResult(tableList, (Location)tempLocation, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
                    lastElIsTable = true;
                    continue block2;
                }
            }
        }
        return result;
    }

    private Table tableConvert(List<ContentPojo.contentElement.InnerCell> cells) {
        Table table = new Table();
        ArrayList<Cell> targetCells = new ArrayList<Cell>();
        table.setCells(targetCells);
        for (ContentPojo.contentElement.InnerCell cell : cells) {
            Cell targetCell = new Cell();
            targetCell.setCol(Integer.valueOf(cell.getCol_index() - 1));
            targetCell.setRow(Integer.valueOf(cell.getRow_index() - 1));
            targetCell.setColSpan(cell.getCol_span());
            targetCell.setRowSpan(cell.getRow_span());
            targetCell.setText(cell.getText() == null ? "" : this.getCellText(cell.getText()));
            targetCells.add(targetCell);
        }
        return table;
    }

    @Override
    public ExtractResult after(List<ExtractResult> list, ResolvablePDFTableConfig config) {
        ExtractResult result = this.dealData(list, config);
        if (result != null) {
            result.setResult(this.afterHandler(result.getResult(), config));
        }
        return result;
    }

    public ExtractResult dealData(List<ExtractResult> list, ResolvablePDFTableConfig config) {
        ExtractResult extractResult = this.getResultByMatchStrategy(list, config);
        String headText = "";
        if (extractResult == null) {
            return null;
        }
        if (!(extractResult.getResult() instanceof List)) {
            return extractResult;
        }
        List tableList = (List)extractResult.getResult();
        Table table = (Table)tableList.get(0);
        List cells = table.getCells();
        for (Cell cell : cells) {
            if (cell.getRow() != 0) continue;
            headText = headText + this.getCellText(cell.getText());
        }
        TempLocation location = new TempLocation();
        location.setContext(headText);
        location.setText(headText);
        location.setFileId(extractResult.getLocation() != null ? extractResult.getLocation().getFileId() : null);
        location.setPageNum(table.getPagenum());
        extractResult.setLocation((Location)location);
        log.info("\u63d0\u53d6>>\u3010ResolvablePDFTableExtractor.after\u3011\u7ed3\u675f,\u8868\u5934\uff1a" + headText);
        return extractResult;
    }

    private String getCellText(String cellText) {
        return StringUtils.isNotBlank((CharSequence)cellText) ? cellText.replaceAll("(\\r?\\n)", "").replaceAll("\\s+", "").trim() : "";
    }
}

